/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.download;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.security.HEX;
import com.huawei.appmarket.component.buoycircle.impl.security.SHA256;
import com.huawei.appmarket.component.buoycircle.impl.update.download.DownloadRecord;
import com.huawei.appmarket.component.buoycircle.impl.update.download.RandomFileOutputStream;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.IOtaUpdate;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.IUpdateCallback;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.UpdateInfo;
import com.huawei.appmarket.component.buoycircle.impl.update.http.CanceledException;
import com.huawei.appmarket.component.buoycircle.impl.update.http.HttpRequestHelper;
import com.huawei.appmarket.component.buoycircle.impl.update.http.IHttpRequestHelper;
import com.huawei.appmarket.component.buoycircle.impl.update.provider.UpdateProvider;
import com.huawei.appmarket.component.buoycircle.impl.utils.Checker;
import com.huawei.appmarket.component.buoycircle.impl.utils.IOUtil;
import java.io.File;
import java.io.IOException;

public class UpdateDownload
implements IOtaUpdate {
    private static final String TAG = "UpdateDownload";
    private final Context mContext;
    private final IHttpRequestHelper mHttp = new HttpRequestHelper();
    private IUpdateCallback mCallback;
    private File mLocalFile;
    private final DownloadRecord mRecord = new DownloadRecord();

    public UpdateDownload(Context context) {
        this.mContext = context.getApplicationContext();
    }

    private synchronized void setListener(IUpdateCallback callback) {
        this.mCallback = callback;
    }

    private synchronized void fireDownloading(int status, int received, int total) {
        if (this.mCallback != null) {
            this.mCallback.onDownloadPackage(status, received, total, this.mLocalFile);
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void cancel() {
        BuoyLog.i(TAG, "Enter cancel.");
        this.setListener(null);
        this.mHttp.cancel();
    }

    @Override
    public void downloadPackage(IUpdateCallback callback, UpdateInfo updateInfo) {
        Checker.checkNonNull(callback, "callback must not be null.");
        BuoyLog.i(TAG, "Enter downloadPackage.");
        this.setListener(callback);
        if (updateInfo == null || !updateInfo.isValid()) {
            BuoyLog.e(TAG, "In downloadPackage, Invalid update info.");
            this.fireDownloading(2201, 0, 0);
            return;
        }
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            BuoyLog.e(TAG, "In downloadPackage, Invalid external storage for downloading file.");
            this.fireDownloading(2204, 0, 0);
            return;
        }
        String packageName = updateInfo.mPackageName;
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            BuoyLog.e(TAG, "In DownloadHelper.downloadPackage, Download the package,  packageName is null: ");
            this.fireDownloading(2201, 0, 0);
            return;
        }
        this.mLocalFile = UpdateProvider.getLocalFile(this.mContext, packageName + ".apk");
        if (this.mLocalFile == null) {
            BuoyLog.e(TAG, "In downloadPackage, Failed to get local file for downloading.");
            this.fireDownloading(2204, 0, 0);
            return;
        }
        File parent = this.mLocalFile.getParentFile();
        if (parent == null || !parent.mkdirs() && !parent.isDirectory()) {
            BuoyLog.e(TAG, "In downloadPackage, Failed to create directory for downloading file.");
            this.fireDownloading(2201, 0, 0);
            return;
        }
        if (parent.getUsableSpace() < (long)(3 * updateInfo.mSize)) {
            BuoyLog.e(TAG, "In downloadPackage, No space for downloading file.");
            this.fireDownloading(2203, 0, 0);
            return;
        }
        try {
            this.downloadPackage(updateInfo);
        }
        catch (CanceledException e2) {
            BuoyLog.w(TAG, "In downloadPackage, Canceled to download the update file.");
            this.fireDownloading(2101, 0, 0);
        }
    }

    private static boolean verifyHash(String hashString, File localFile) {
        byte[] hashBytes = SHA256.digest(localFile);
        return hashBytes != null && HEX.encodeHexString(hashBytes, true).equalsIgnoreCase(hashString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadPackage(UpdateInfo mUpdateInfo) throws CanceledException {
        RandomFileOutputStream rfos;
        block18: {
            block17: {
                block16: {
                    block15: {
                        BuoyLog.i(TAG, "Enter downloadPackage.");
                        rfos = null;
                        try {
                            block20: {
                                String packageName;
                                block19: {
                                    packageName = mUpdateInfo.mPackageName;
                                    if (TextUtils.isEmpty((CharSequence)packageName)) {
                                        BuoyLog.e(TAG, "In DownloadHelper.downloadPackage, Download the package,  packageName is null: ");
                                        this.fireDownloading(2201, 0, 0);
                                        return;
                                    }
                                    this.mRecord.load(this.getContext(), packageName);
                                    if (!this.mRecord.isValid(mUpdateInfo.mUri, mUpdateInfo.mSize, mUpdateInfo.mHash)) break block19;
                                    if (this.mRecord.getReceived() == this.mRecord.getSize()) {
                                        if (UpdateDownload.verifyHash(mUpdateInfo.mHash, this.mLocalFile)) {
                                            this.fireDownloading(2000, 0, 0);
                                            this.mHttp.close();
                                            break block15;
                                        }
                                        this.mRecord.init(mUpdateInfo.mUri, mUpdateInfo.mSize, mUpdateInfo.mHash);
                                        rfos = this.newRandomFileOutputStream(this.mLocalFile, mUpdateInfo.mSize, packageName);
                                        break block20;
                                    } else {
                                        rfos = this.newRandomFileOutputStream(this.mLocalFile, mUpdateInfo.mSize, packageName);
                                        rfos.seek(this.mRecord.getReceived());
                                    }
                                    break block20;
                                }
                                this.mRecord.init(mUpdateInfo.mUri, mUpdateInfo.mSize, mUpdateInfo.mHash);
                                rfos = this.newRandomFileOutputStream(this.mLocalFile, mUpdateInfo.mSize, packageName);
                            }
                            int statusCode = this.mHttp.get(mUpdateInfo.mUri, rfos, this.mRecord.getReceived(), this.mRecord.getSize());
                            if (statusCode != 200 && statusCode != 206) {
                                BuoyLog.e(TAG, "In DownloadHelper.downloadPackage, Download the package, HTTP code: " + statusCode);
                                this.fireDownloading(2201, 0, 0);
                                this.mHttp.close();
                                break block16;
                            }
                            if (!UpdateDownload.verifyHash(mUpdateInfo.mHash, this.mLocalFile)) {
                                this.fireDownloading(2202, 0, 0);
                                this.mHttp.close();
                                break block17;
                            }
                            this.fireDownloading(2000, 0, 0);
                            this.mHttp.close();
                            break block18;
                        }
                        catch (IOException e2) {
                            BuoyLog.e(TAG, "In DownloadHelper.downloadPackage, Failed to download.");
                            this.fireDownloading(2201, 0, 0);
                            return;
                        }
                    }
                    IOUtil.closeQuietly(rfos);
                    return;
                }
                IOUtil.closeQuietly(rfos);
                return;
            }
            IOUtil.closeQuietly(rfos);
            return;
        }
        IOUtil.closeQuietly(rfos);
        return;
        finally {
            this.mHttp.close();
            IOUtil.closeQuietly(rfos);
        }
    }

    private RandomFileOutputStream newRandomFileOutputStream(File file, final int size, final String packageName) throws IOException {
        return new RandomFileOutputStream(file, size){
            private long lastRecvTime;
            private int received;
            {
                super(file, length);
                this.lastRecvTime = 0L;
                this.received = UpdateDownload.this.mRecord.getReceived();
            }

            @Override
            public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
                super.write(buffer, byteOffset, byteCount);
                this.received += byteCount;
                if (this.received > 0xC800000) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (Math.abs(now - this.lastRecvTime) > 1000L) {
                    this.lastRecvTime = now;
                    this.onNotify(this.received);
                }
                if (this.received == size) {
                    this.onNotify(this.received);
                }
            }

            private void onNotify(int received) {
                UpdateDownload.this.mRecord.update(UpdateDownload.this.getContext(), received, packageName);
                UpdateDownload.this.fireDownloading(2100, received, size);
            }
        };
    }
}

