/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.http;

import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.http.CanceledException;
import com.huawei.appmarket.component.buoycircle.impl.update.http.HttpsUtils;
import com.huawei.appmarket.component.buoycircle.impl.update.http.IHttpRequestHelper;
import com.huawei.appmarket.component.buoycircle.impl.utils.IOUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class HttpRequestHelper
implements IHttpRequestHelper {
    private static final String TAG = "HttpRequestHelper";
    private static final int TIMEOUT = 30000;
    private static final int BUFF_SIZE = 4096;
    private HttpURLConnection mConnection;
    private static final int STATUS_CLOSED = -1;
    private static final int STATUS_CANCELED = 1;
    private static final int STATUS_OPENED = 0;
    private volatile int mStatus = -1;

    @Override
    public void close() {
        this.mStatus = -1;
        if (this.mConnection != null) {
            this.mConnection.disconnect();
        }
    }

    @Override
    public void cancel() {
        this.mStatus = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int post(String url, InputStream input, OutputStream output) throws IOException, CanceledException {
        int statusCode = -1;
        InputStream is = null;
        OutputStream os = null;
        try {
            this.openConnection(url);
            this.mConnection.setDoInput(true);
            this.mConnection.setDoOutput(true);
            this.mConnection.setRequestMethod("POST");
            os = this.mConnection.getOutputStream();
            this.copy(input, os);
            os.flush();
            statusCode = this.mConnection.getResponseCode();
            if (statusCode == 200) {
                is = this.mConnection.getInputStream();
                this.copy(new BufferedInputStream(is, 4096), output);
                output.flush();
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(is);
            IOUtil.closeQuietly(os);
            throw throwable;
        }
        IOUtil.closeQuietly(is);
        IOUtil.closeQuietly(os);
        return statusCode;
    }

    @Override
    public int get(String url, OutputStream output) throws IOException, CanceledException {
        return this.get(url, output, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(String url, OutputStream output, int start, int end) throws IOException, CanceledException {
        int statusCode = -1;
        InputStream is = null;
        try {
            this.openConnection(url);
            this.mConnection.setRequestMethod("GET");
            if (start > 0) {
                this.mConnection.addRequestProperty("Range", "bytes=" + start + "-" + end);
            }
            statusCode = this.mConnection.getResponseCode();
            if (start > 0 && statusCode == 206 || start <= 0 && statusCode == 200) {
                is = this.mConnection.getInputStream();
                this.copy(new BufferedInputStream(is, 4096), output);
                output.flush();
            }
        }
        finally {
            IOUtil.closeQuietly(is);
        }
        return statusCode;
    }

    private void openConnection(String url) throws IOException {
        if (this.mStatus == 0) {
            BuoyLog.e(TAG, "Not allowed to repeat open http(s) connection.");
        }
        this.mConnection = (HttpURLConnection)new URL(url).openConnection();
        if (this.mConnection instanceof HttpsURLConnection) {
            HttpsUtils.setSSLSocketFactory((HttpsURLConnection)this.mConnection);
        }
        this.mConnection.setConnectTimeout(30000);
        this.mConnection.setReadTimeout(30000);
        this.mConnection.setUseCaches(false);
        this.mStatus = 0;
    }

    private void copy(InputStream input, OutputStream output) throws IOException, CanceledException {
        int n2;
        byte[] buffer = new byte[4096];
        while (-1 != (n2 = input.read(buffer))) {
            output.write(buffer, 0, n2);
            if (this.mStatus != 1) continue;
            throw new CanceledException("HTTP(s) request was canceled.");
        }
    }
}

