/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.manager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.huawei.appmarket.component.buoycircle.impl.delegete.BuoyBridgeActivity;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.UpdateBean;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.AbsUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import java.io.Serializable;
import java.util.ArrayList;

public class UpdateManager {
    private static final String TAG = "UpdateManager";

    public static void startUpdate(Activity activity, int requestCode, UpdateBean bean) {
        if (activity == null || bean == null) {
            return;
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        PackageManagerHelper.PackageStates states = UpdateManager.getHiappStatus((Context)activity);
        if (states == PackageManagerHelper.PackageStates.NOT_INSTALLED || states == PackageManagerHelper.PackageStates.DISABLED) {
            typeList.add(6);
        } else if (UpdateManager.getSilentInstallSupport((Context)activity)) {
            BuoyLog.i(TAG, "current hiapp not support silent install");
            typeList.add(0);
            typeList.add(6);
        } else {
            BuoyLog.i(TAG, "current hiapp support silent install");
            typeList.add(5);
            typeList.add(6);
        }
        bean.setTypeList(typeList);
        Intent intent = BuoyBridgeActivity.getIntentStartBridgeActivity(activity, AbsUpdateDelegate.getClassName((Integer)typeList.get(0)));
        intent.putExtra("intent.extra.update.info", (Serializable)bean);
        activity.startActivityForResult(intent, requestCode);
    }

    private static boolean getSilentInstallSupport(Context context) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        int hiAppVerisonCode = pmHelper.getPackageVersionCode("com.huawei.appmarket");
        return (long)hiAppVerisonCode >= 70203000L;
    }

    private static PackageManagerHelper.PackageStates getHiappStatus(Context context) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        return pmHelper.getPackageStates("com.huawei.appmarket");
    }
}

