/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.provider;

import android.content.Context;
import android.net.Uri;
import com.huawei.appmarket.component.buoycircle.impl.utils.Checker;
import java.io.File;
import java.io.IOException;

class ContentUriHelper {
    private static final String TAG = "ContentUriHelper";
    private Context mContext;
    private String mUpdateRoot;

    ContentUriHelper() {
    }

    public void setContext(Context context) {
        Checker.checkNonNull(context, "context nust not be null.");
        this.mContext = context;
    }

    public File getLocalFile(String path) {
        String root = this.getUpdateRoot();
        if (root == null) {
            return null;
        }
        return ContentUriHelper.getCanonicalFile(new File(root, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateRoot() {
        Context context = Checker.assertNonNull(this.mContext, "mContext is null, call setContext first.");
        ContentUriHelper contentUriHelper = this;
        synchronized (contentUriHelper) {
            if (this.mUpdateRoot == null) {
                this.mUpdateRoot = context.getExternalCacheDir() != null ? ContentUriHelper.getCanonicalPath(context.getExternalCacheDir()) : ContentUriHelper.getCanonicalPath(context.getFilesDir());
            }
            return this.mUpdateRoot;
        }
    }

    public Uri getUriForFile(File file, String authority) {
        String path = ContentUriHelper.getCanonicalPath(file);
        if (path == null) {
            return null;
        }
        String newPath = this.mapPath(path);
        if (newPath == null) {
            return null;
        }
        return new Uri.Builder().scheme("content").authority(authority).encodedPath(newPath).build();
    }

    private String mapPath(String path) {
        String root = this.getUpdateRoot();
        if (root == null) {
            return null;
        }
        if (!path.startsWith(root)) {
            return null;
        }
        int start = root.endsWith("/") ? root.length() : root.length() + 1;
        return Uri.encode((String)TAG) + '/' + path.substring(start);
    }

    File getFileForUri(Uri uri) {
        String path = uri.getEncodedPath();
        if (path == null) {
            return null;
        }
        String newPath = this.unmapPath(path);
        if (newPath == null) {
            return null;
        }
        return ContentUriHelper.getCanonicalFile(new File(newPath));
    }

    private String unmapPath(String path) {
        String root = this.getUpdateRoot();
        if (root == null) {
            return null;
        }
        int index = path.indexOf(47, 1);
        if (index < 0) {
            return null;
        }
        String tag = Uri.decode((String)path.substring(1, index));
        if (!TAG.equals(tag)) {
            return null;
        }
        String newPath = ContentUriHelper.getCanonicalPath(new File(root, Uri.decode((String)path.substring(index + 1))));
        if (newPath == null) {
            return null;
        }
        if (!newPath.startsWith(root)) {
            return null;
        }
        return newPath;
    }

    private static String getCanonicalPath(File path) {
        if (path == null) {
            return null;
        }
        try {
            return path.getCanonicalPath();
        }
        catch (IOException e2) {
            return null;
        }
    }

    private static File getCanonicalFile(File path) {
        if (path == null) {
            return null;
        }
        try {
            return path.getCanonicalFile();
        }
        catch (IOException e2) {
            return null;
        }
    }
}

