/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.huawei.appmarket.component.buoycircle.impl.update.provider.ContentUriHelper;
import java.io.File;
import java.io.FileNotFoundException;

public class UpdateProvider
extends ContentProvider {
    public static final String AUTHORITIES_SUFFIX = ".hms.update.provider";
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static ContentUriHelper mUriHelper = new ContentUriHelper();

    public static Uri getUriForFile(Context context, String authority, File file) {
        mUriHelper.setContext(context);
        return mUriHelper.getUriForFile(file, authority);
    }

    public static File getLocalFile(Context context, String path) {
        mUriHelper.setContext(context);
        return mUriHelper.getLocalFile(path);
    }

    public boolean onCreate() {
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        if (info.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        mUriHelper.setContext(context);
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("No external updates");
    }

    public String getType(Uri uri) {
        File file = mUriHelper.getFileForUri(uri);
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0) {
            String extName = fileName.substring(lastDot + 1);
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extName);
            if (!TextUtils.isEmpty((CharSequence)mime)) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        File file = mUriHelper.getFileForUri(uri);
        if (projection == null) {
            projection = COLUMNS;
        }
        String[] cols = new String[projection.length];
        Object[] values = new Object[projection.length];
        int i2 = 0;
        for (String col : projection) {
            if ("_display_name".equals(col)) {
                cols[i2] = "_display_name";
                values[i2++] = file.getName();
                continue;
            }
            if (!"_size".equals(col)) continue;
            cols[i2] = "_size";
            values[i2++] = file.length();
        }
        cols = UpdateProvider.copyOf(cols, i2);
        values = UpdateProvider.copyOf(values, i2);
        MatrixCursor cursor = new MatrixCursor(cols, 1);
        cursor.addRow(values);
        return cursor;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        File file = mUriHelper.getFileForUri(uri);
        return file.delete() ? 1 : 0;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        File file = mUriHelper.getFileForUri(uri);
        int fileMode = UpdateProvider.modeToMode(mode);
        return ParcelFileDescriptor.open((File)file, (int)fileMode);
    }

    private static int modeToMode(String mode) {
        int modeBits;
        if ("r".equals(mode)) {
            modeBits = 0x10000000;
        } else if ("w".equals(mode) || "wt".equals(mode)) {
            modeBits = 0x2C000000;
        } else if ("wa".equals(mode)) {
            modeBits = 0x2A000000;
        } else if ("rw".equals(mode)) {
            modeBits = 0x38000000;
        } else if ("rwt".equals(mode)) {
            modeBits = 0x3C000000;
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        return modeBits;
    }

    private static String[] copyOf(String[] original, int newLength) {
        String[] result = new String[newLength];
        System.arraycopy(original, 0, result, 0, newLength);
        return result;
    }

    private static Object[] copyOf(Object[] original, int newLength) {
        Object[] result = new Object[newLength];
        System.arraycopy(original, 0, result, 0, newLength);
        return result;
    }
}

