/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.huawei.appmarket.component.buoycircle.impl.bi.BuoyAnalyticHelper;
import com.huawei.appmarket.component.buoycircle.impl.delegete.IBridgeActivityDelegate;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.UpdateBean;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.HiAppUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.OtaUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.SilentUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.AbstractDialog;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class AbsUpdateDelegate
implements IBridgeActivityDelegate {
    private static final String TAG = "AbsUpdateDelegate";
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = 8;
    public static final int RESULT_CANCELED = 13;
    public static final int RESULT_TIMEOUT = 14;
    protected static final int SILENT_DOWNLOAD_REQUEST_CODE = 2000;
    protected static final int HIAPP_REQUEST_CODE = 2005;
    protected static final int HIAPP_DL_REQUEST_CODE = 2006;
    public WeakReference<Activity> mThisWeakRef;
    public IBridgeActivityDelegate mBridgeActivityDelegate;
    protected UpdateBean bean = null;
    protected AbstractDialog mLatestDialog = null;
    protected boolean needTransfer = false;
    protected int updateType = -1;
    protected String mPackageName = null;
    protected String mClientAppName = null;
    protected int mClientVersionCode = 0;
    protected String mClientAppId = null;
    private String sdkVersionCode;

    public void onCancel(AbstractDialog abstractDialog) {
    }

    public void onDoWork(AbstractDialog abstractDialog) {
    }

    abstract void showDialog(Class<? extends AbstractDialog> var1);

    abstract void userCancelUpdate();

    public Activity getActivity() {
        if (this.mThisWeakRef == null) {
            return null;
        }
        return (Activity)this.mThisWeakRef.get();
    }

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        this.mThisWeakRef = new WeakReference<Activity>(activity);
        if (this.bean == null) {
            Intent intent = activity.getIntent();
            if (intent == null) {
                return;
            }
            this.bean = (UpdateBean)intent.getSerializableExtra("intent.extra.update.info");
            if (this.bean == null) {
                return;
            }
        }
        this.mPackageName = this.bean.getClientPackageName();
        this.mClientAppName = this.bean.getClientAppName();
        this.mClientVersionCode = this.bean.getClientVersionCode();
        this.mClientAppId = this.bean.getClientAppId();
        this.sdkVersionCode = this.bean.getSdkVersionCode();
        this.mBridgeActivityDelegate = null;
        this.needTransfer = false;
        this.updateType = -1;
    }

    @Override
    public void onBridgeActivityDestroy() {
        this.mThisWeakRef = null;
        this.dismissDialog();
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onBridgeActivityDestroy();
        }
    }

    @Override
    public void onBridgeConfigurationChanged() {
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onBridgeConfigurationChanged();
            return;
        }
        if (this.mLatestDialog == null) {
            return;
        }
        Class<?> clzDlg = this.mLatestDialog.getClass();
        this.mLatestDialog.dismiss();
        this.mLatestDialog = null;
        this.showDialog(clzDlg);
    }

    protected void dismissDialog() {
        if (this.mLatestDialog == null) {
            return;
        }
        try {
            this.mLatestDialog.dismiss();
            this.mLatestDialog = null;
        }
        catch (IllegalStateException e2) {
            BuoyLog.e(TAG, "In dismissDialog, Failed to dismiss the dialog.");
        }
    }

    protected void biReportEvent(int result, int type) {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        String dealResult = this.dealUpdateResult(result, type);
        String triggerApi = null;
        triggerApi = "com.huawei.hwid".equals(activity.getPackageName()) ? "hms.buoycircle" : "core.connnect";
        BuoyAnalyticHelper.getInstance().onReportUpdateHiAppResult((Context)activity, this.mPackageName, this.sdkVersionCode, triggerApi, dealResult, type);
    }

    private String dealUpdateResult(int result, int type) {
        String newResult = String.valueOf(result);
        switch (type) {
            case 0: {
                return "0000" + newResult;
            }
            case 6: {
                return "4000" + newResult;
            }
            case 5: {
                return "5000" + newResult;
            }
            case 4: {
                return "6000" + newResult;
            }
        }
        return newResult;
    }

    protected boolean startNextWizard(boolean needConfirm) {
        Activity activity = this.getActivity();
        if (activity == null) {
            return false;
        }
        ArrayList typeList = this.bean.getTypeList();
        typeList.remove(0);
        if (this.mBridgeActivityDelegate == null) {
            this.getBridgeActivityDelegate(typeList);
        }
        if (this.mBridgeActivityDelegate != null) {
            this.needTransfer = true;
            this.bean.setTypeList(typeList);
            this.bean.setNeedConfirm(needConfirm);
            this.mBridgeActivityDelegate.onBridgeActivityCreate(activity);
            return true;
        }
        return false;
    }

    private void getBridgeActivityDelegate(ArrayList arrayList) {
        String className = null;
        if (arrayList != null && arrayList.size() > 0) {
            className = AbsUpdateDelegate.getClassName((Integer)arrayList.get(0));
        }
        if (className == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Class<IBridgeActivityDelegate> delegateClass = clazz.asSubclass(IBridgeActivityDelegate.class);
            this.mBridgeActivityDelegate = delegateClass.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
            BuoyLog.e(TAG, "getBridgeActivityDelegate meet exception");
        }
    }

    protected void finishBridgeActivity(int result, int type) {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        this.biReportEvent(result, type);
        Intent data = new Intent();
        data.putExtra("intent.extra.DELEGATE_CLASS_OBJECT", this.getClass().getName());
        data.putExtra("intent.extra.RESULT", result);
        activity.setResult(-1, data);
        activity.finish();
    }

    @Override
    public void onKeyUp(int keyCode, KeyEvent event) {
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onKeyUp(keyCode, event);
        }
    }

    protected boolean isUpdated(String packageName, int versionNeed) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return false;
        }
        PackageManagerHelper pmHelper = new PackageManagerHelper((Context)activity);
        int versionCode = pmHelper.getPackageVersionCode(packageName);
        return versionCode >= versionNeed;
    }

    public static String getClassName(int type) {
        switch (type) {
            case 0: {
                return SilentUpdateDelegate.class.getName();
            }
            case 6: {
                return OtaUpdateDelegate.class.getName();
            }
            case 5: {
                return HiAppUpdateDelegate.class.getName();
            }
        }
        return "";
    }

    public static interface UpdateType {
        public static final int SILENT = 0;
        public static final int HIAPP_WAP = 4;
        public static final int HIAPP = 5;
        public static final int HIAPP_DL = 6;
        public static final int INIT = -1;
    }
}

