/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.receive.PackageAddedReceiver;
import com.huawei.appmarket.component.buoycircle.impl.update.receive.SilentInstallReceiver;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.AbsUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.AbstractDialog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.DownloadProgressDialog;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SilentUpdateDelegate
extends AbsUpdateDelegate {
    private static final String TAG = "SilentUpdateDelegate";
    private BroadcastReceiver HiAppReciever;
    private BroadcastReceiver systemAppAddedReceiver;
    private Handler handler = new Handler();
    private static final int DOWNLOAD_OVER_TIME = 20000;
    private static final int INSTALL_OVER_TIME = 60000;
    private static final String PACKAGE_DATA_SCHEME = "package";
    private int mCurProgress = 0;
    private Handler silentInstallHandler = new Handler(){

        public void handleMessage(Message msg) {
            Bundle bundle = (Bundle)msg.obj;
            switch (msg.what) {
                case 101: {
                    SilentUpdateDelegate.this.handleDownloadStatus(bundle);
                    break;
                }
                case 102: {
                    SilentUpdateDelegate.this.handlerDownloadProgress(bundle);
                    break;
                }
                case 103: {
                    SilentUpdateDelegate.this.handlerInstallStatus(bundle);
                    break;
                }
            }
        }
    };

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        super.onBridgeActivityCreate(activity);
        if (this.bean == null) {
            return;
        }
        this.updateType = 0;
        if (!this.silentInstall(activity)) {
            if (!this.startNextWizard(true)) {
                this.finishBridgeActivity(8, this.updateType);
            } else {
                this.biReportEvent(8, this.updateType);
            }
        }
    }

    @Override
    public void onBridgeActivityDestroy() {
        this.handler.removeCallbacksAndMessages(null);
        this.unRegistReceiver();
        super.onBridgeActivityDestroy();
    }

    @Override
    public boolean onBridgeActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            return this.mBridgeActivityDelegate.onBridgeActivityResult(requestCode, resultCode, data);
        }
        if (requestCode == this.getRequestCode()) {
            if (resultCode == 0) {
                this.registReceiver();
                this.refreshOverTime(20000);
                return true;
            }
            if (resultCode == 4 || resultCode == 7) {
                this.userCancelUpdate();
                return true;
            }
            if (!this.startNextWizard(true)) {
                this.finishBridgeActivity(resultCode, this.updateType);
            } else {
                this.biReportEvent(resultCode, this.updateType);
            }
            return true;
        }
        return false;
    }

    private boolean silentInstall(Activity activity) {
        if (TextUtils.isEmpty((CharSequence)this.mPackageName)) {
            return false;
        }
        Intent startIntent = new Intent("com.huawei.appmarket.intent.action.ThirdUpdateAction");
        startIntent.setPackage("com.huawei.appmarket");
        JSONArray jsonApp = new JSONArray();
        JSONObject hmsObj = new JSONObject();
        try {
            hmsObj.put("pkgName", (Object)this.mPackageName);
            hmsObj.put("versioncode", this.mClientVersionCode);
        }
        catch (JSONException e2) {
            BuoyLog.e(TAG, "create hmsJsonObject fail");
            return false;
        }
        jsonApp.put((Object)hmsObj);
        startIntent.putExtra("params", jsonApp.toString());
        startIntent.putExtra("isHmsOrApkUpgrade", this.bean.isHmsOrApkUpgrade());
        startIntent.putExtra("buttonDlgY", ResourceLoaderUtil.getString("c_buoycircle_install"));
        startIntent.putExtra("buttonDlgN", ResourceLoaderUtil.getString("c_buoycircle_cancel"));
        startIntent.putExtra("upgradeDlgContent", ResourceLoaderUtil.getString("c_buoycircle_update_message_new", "%P"));
        try {
            activity.startActivityForResult(startIntent, this.getRequestCode());
        }
        catch (ActivityNotFoundException e3) {
            BuoyLog.e(TAG, "ActivityNotFoundException");
            return false;
        }
        return true;
    }

    @Override
    public void onBridgeConfigurationChanged() {
        super.onBridgeConfigurationChanged();
    }

    private void registReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.huawei.appmarket.service.downloadservice.Receiver");
        filter.addAction("com.huawei.appmarket.service.downloadservice.progress.Receiver");
        filter.addAction("com.huawei.appmarket.service.installerservice.Receiver");
        this.HiAppReciever = new SilentInstallReceiver(this.silentInstallHandler);
        IntentFilter appfilter = new IntentFilter();
        appfilter.addAction("android.intent.action.PACKAGE_ADDED");
        appfilter.addDataScheme(PACKAGE_DATA_SCHEME);
        this.systemAppAddedReceiver = new PackageAddedReceiver(this.silentInstallHandler);
        Activity activity = this.getActivity();
        if (null != activity) {
            activity.registerReceiver(this.HiAppReciever, filter);
            activity.registerReceiver(this.systemAppAddedReceiver, appfilter);
        }
    }

    private void unRegistReceiver() {
        Activity activity = this.getActivity();
        if (null != activity) {
            if (this.HiAppReciever != null) {
                activity.unregisterReceiver(this.HiAppReciever);
                this.HiAppReciever = null;
            }
            if (this.systemAppAddedReceiver != null) {
                activity.unregisterReceiver(this.systemAppAddedReceiver);
                this.systemAppAddedReceiver = null;
            }
        }
    }

    @Override
    public int getRequestCode() {
        return 2000;
    }

    private void refreshOverTime(int time) {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.postDelayed((Runnable)new HandlerRunnable(), (long)time);
    }

    private void silentInstallFail(int result) {
        this.handler.removeCallbacksAndMessages(null);
        this.unRegistReceiver();
        this.dismissDialog();
        if (!this.startNextWizard(false)) {
            this.finishBridgeActivity(result, this.updateType);
        } else {
            this.biReportEvent(result, this.updateType);
        }
    }

    @Override
    public void onKeyUp(int keyCode, KeyEvent event) {
        super.onKeyUp(keyCode, event);
    }

    private void handleDownloadStatus(Bundle bundle) {
        String packageName = null;
        if (bundle.containsKey("UpgradePkgName")) {
            packageName = bundle.getString("UpgradePkgName");
        }
        if (packageName == null || !packageName.equals(this.mPackageName)) {
            return;
        }
        if (bundle.containsKey("downloadtask.status")) {
            int status = bundle.getInt("downloadtask.status");
            if (status == 3 || status == 5 || status == 6 || status == 8) {
                this.silentInstallFail(status);
            } else if (status == 4) {
                this.refreshOverTime(60000);
            } else {
                this.refreshOverTime(20000);
            }
        }
    }

    private void handlerDownloadProgress(Bundle bundle) {
        String packageName = null;
        if (bundle.containsKey("UpgradePkgName")) {
            packageName = bundle.getString("UpgradePkgName");
        }
        if (packageName == null || !packageName.equals(this.mPackageName)) {
            return;
        }
        if (bundle.containsKey("UpgradeDownloadProgress") && bundle.containsKey("UpgradeAppName")) {
            int progress = bundle.getInt("UpgradeDownloadProgress");
            this.refreshOverTime(20000);
            if (progress >= 99) {
                progress = 99;
            }
            this.mCurProgress = progress;
            if (this.mLatestDialog == null) {
                this.showDialog(DownloadProgressDialog.class);
            }
            if (this.mLatestDialog != null) {
                ((DownloadProgressDialog)this.mLatestDialog).setDownloading(progress);
            }
        }
    }

    private void handlerInstallStatus(Bundle bundle) {
        if (bundle.containsKey("packagename") && bundle.containsKey("status")) {
            String packageName = bundle.getString("packagename");
            int status = bundle.getInt("status");
            if (packageName == null || !packageName.equals(this.mPackageName)) {
                return;
            }
            if (status == 2) {
                this.handler.removeCallbacksAndMessages(null);
                if (this.mLatestDialog != null) {
                    ((DownloadProgressDialog)this.mLatestDialog).setDownloading(100);
                }
                this.finishBridgeActivity(0, this.updateType);
            } else if (status == -1 || status == -2) {
                this.silentInstallFail(status);
            } else {
                this.refreshOverTime(60000);
            }
        }
    }

    @Override
    void showDialog(Class<? extends AbstractDialog> dialogClass) {
        try {
            AbstractDialog dialog = dialogClass.newInstance();
            if (this.mCurProgress > 0 && dialog instanceof DownloadProgressDialog) {
                ((DownloadProgressDialog)dialog).intProgress(this.mCurProgress);
            }
            dialog.show(this);
            this.mLatestDialog = dialog;
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException e2) {
            BuoyLog.e(TAG, "In showDialog, Failed to show the dialog.");
        }
    }

    @Override
    void userCancelUpdate() {
        this.finishBridgeActivity(13, this.updateType);
    }

    private class HandlerRunnable
    implements Runnable {
        private HandlerRunnable() {
        }

        @Override
        public void run() {
            SilentUpdateDelegate.this.silentInstallFail(14);
        }
    }
}

