/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;

public class Util {
    private static final String TAG = "Util";
    private static final String META_APPID_NAME = "com.huawei.hms.client.appid";
    private static final String META_APPID_NAME_PREFIX = "appid=";

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getBuildVersion() {
        return String.valueOf(Build.DISPLAY);
    }

    public static String getMetaDataAppId(Context context) {
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            BuoyLog.e(TAG, "In getMetaDataAppId, Failed to get 'PackageManager' instance.");
            return "";
        }
        try {
            Object appIdObj;
            ApplicationInfo appInfo = pm.getApplicationInfo(context.getPackageName(), 128);
            if (appInfo != null && appInfo.metaData != null && (appIdObj = appInfo.metaData.get(META_APPID_NAME)) != null) {
                String appid = String.valueOf(appIdObj);
                if (appid.startsWith(META_APPID_NAME_PREFIX)) {
                    return appid.substring(META_APPID_NAME_PREFIX.length());
                }
                return appid;
            }
            BuoyLog.e(TAG, "In getMetaDataAppId, Failed to read meta data for the AppID.");
            return "";
        }
        catch (PackageManager.NameNotFoundException e2) {
            BuoyLog.e(TAG, "In getMetaDataAppId, Failed to read meta data for the AppID.");
            return "";
        }
    }
}

