/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.utils;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WindowUtil {
    private static final String TAG = "WindowUtil";
    private static final int STATUS_NO_INITED = -1;
    private static final int INIT_X = 0;
    private static final float POSITION_Y_PERCENT = 0.43333334f;
    private static int statusBarHeight = -1;
    private static int screenH;

    public static int dp2Px(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public static float dp2px(Context context, int dp) {
        return (float)dp * context.getResources().getDisplayMetrics().density;
    }

    public static void setStatusBarHeight(Context context) {
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
            if ((attrs.flags & 0x400) == 1024) {
                statusBarHeight = 0;
            }
        } else {
            statusBarHeight = -1;
        }
    }

    public static int getStatusBarHeight(Context context) {
        if (statusBarHeight == -1) {
            try {
                Class<?> c2 = Class.forName("com.android.internal.R$dimen");
                Object o2 = c2.newInstance();
                Field field = c2.getField("status_bar_height");
                int x2 = (Integer)field.get(o2);
                statusBarHeight = context.getResources().getDimensionPixelSize(x2);
            }
            catch (ClassNotFoundException e2) {
                statusBarHeight = 0;
                BuoyLog.e(TAG, "getStatusBarHeight ClassNotFoundException");
            }
            catch (InstantiationException e3) {
                statusBarHeight = 0;
                BuoyLog.e(TAG, "getStatusBarHeight InstantiationException");
            }
            catch (IllegalAccessException e4) {
                statusBarHeight = 0;
                BuoyLog.e(TAG, "getStatusBarHeight IllegalAccessException");
            }
            catch (NoSuchFieldException e5) {
                statusBarHeight = 0;
                BuoyLog.e(TAG, "getStatusBarHeight NoSuchFieldException");
            }
            catch (Exception e6) {
                statusBarHeight = 0;
                BuoyLog.e(TAG, "getStatusBarHeight Exception");
            }
        }
        return statusBarHeight;
    }

    public static boolean isShowStatusBar(Context context) {
        return WindowUtil.getStatusBarHeight(context) > 0;
    }

    public static int getScreenH(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowM = (WindowManager)context.getSystemService("window");
        windowM.getDefaultDisplay().getMetrics(dm);
        screenH = dm.heightPixels;
        return screenH;
    }

    public static int getScreenW(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowM = (WindowManager)context.getSystemService("window");
        windowM.getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int getDefaultPositionY(Context context) {
        if (context == null) {
            return 0;
        }
        int positionY = (int)(0.43333334f * (float)WindowUtil.getScreenH(context));
        BuoyLog.d(TAG, "the default positionY:" + positionY + ", screenH:" + WindowUtil.getScreenH(context));
        return positionY;
    }

    public static int getDefaultPositionX(Context context) {
        if (context == null) {
            return 0;
        }
        return WindowUtil.dp2Px(context, 0.0f);
    }

    public static DisplayMetrics getFullDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (context == null) {
            return displayMetrics;
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        try {
            Class<?> c2 = Class.forName("android.view.Display");
            Method method = c2.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, displayMetrics);
        }
        catch (ClassNotFoundException e2) {
            BuoyLog.e(TAG, "get full display metrics error, ClassNotFoundException");
        }
        catch (NoSuchMethodException e3) {
            BuoyLog.e(TAG, "get full display metrics error, NoSuchMethodException");
        }
        catch (IllegalAccessException e4) {
            BuoyLog.e(TAG, "get full display metrics error, IllegalAccessException");
        }
        catch (IllegalArgumentException e5) {
            BuoyLog.e(TAG, "get full display metrics error, IllegalArgumentException");
        }
        catch (InvocationTargetException e6) {
            BuoyLog.e(TAG, "get full display metrics error, InvocationTargetException");
        }
        return displayMetrics;
    }

    public static int getTotalWidth(Context context) {
        DisplayMetrics displayMetrics = WindowUtil.getFullDisplayMetrics(context);
        return displayMetrics.widthPixels;
    }

    public static boolean isOverStatus(WindowManager.LayoutParams params) {
        int overStatusFlag = 296;
        return params != null && (params.flags & overStatusFlag) == overStatusFlag;
    }
}

