/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;
import com.huawei.appmarket.component.buoycircle.impl.utils.WindowUtil;
import com.huawei.appmarket.component.buoycircle.impl.view.FloatWindowBadgeParams;

public class FloatWindowBadge
extends TextView {
    public FloatWindowBadge(Context context) {
        super(context, null, 16842884);
    }

    public void init(FloatWindowBadgeParams params) {
        if (!(this.getLayoutParams() instanceof FrameLayout.LayoutParams) && params != null) {
            FrameLayout.LayoutParams layoutParams = params.getLayoutParams(this.getContext());
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.setBackgroundResource(ResourceLoaderUtil.getDrawableId("c_buoycircle_red_dot"));
        this.setGravity(17);
        this.setBadgeCount("");
    }

    public void setBadgeLayoutParams(FloatWindowBadgeParams params) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.getLayoutParams();
        if (layoutParams == null || params == null) {
            return;
        }
        layoutParams.rightMargin = WindowUtil.dp2Px(this.getContext(), params.getRightMargin());
        layoutParams.leftMargin = WindowUtil.dp2Px(this.getContext(), params.getLeftMargin());
        layoutParams.topMargin = WindowUtil.dp2Px(this.getContext(), params.getTopMargin());
        layoutParams.bottomMargin = WindowUtil.dp2Px(this.getContext(), params.getBottomMargin());
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setBadgeCount(String count) {
        this.setText(count);
    }

    public void setBadgeGravity(int gravity) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.gravity = gravity;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public int getBadgeGravity() {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        return params.gravity;
    }

    public void setTargetView(View target) {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (target == null) {
            return;
        }
        if (target.getParent() instanceof ViewGroup) {
            ViewGroup parentContainer = (ViewGroup)target.getParent();
            int groupIndex = parentContainer.indexOfChild(target);
            parentContainer.removeView(target);
            FrameLayout badgeContainer = new FrameLayout(this.getContext());
            ViewGroup.LayoutParams parentLayoutParams = target.getLayoutParams();
            badgeContainer.setLayoutParams(parentLayoutParams);
            target.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            parentContainer.addView((View)badgeContainer, groupIndex, parentLayoutParams);
            badgeContainer.addView(target);
            badgeContainer.addView((View)this);
        }
    }
}

