/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.view;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.huawei.appmarket.component.buoycircle.api.AppInfo;
import com.huawei.appmarket.component.buoycircle.impl.bi.BuoyAnalyticHelper;
import com.huawei.appmarket.component.buoycircle.impl.cutout.BuoyCutoutHelper;
import com.huawei.appmarket.component.buoycircle.impl.cutout.CutoutInfo;
import com.huawei.appmarket.component.buoycircle.impl.delegete.BuoyBridgeActivity;
import com.huawei.appmarket.component.buoycircle.impl.delegete.BuoyHideDelegate;
import com.huawei.appmarket.component.buoycircle.impl.delegete.BuoyUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyAutoHideNoticeManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyAutoHideSensorManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyHideCacheManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.FloatWindowManager;
import com.huawei.appmarket.component.buoycircle.impl.remote.BuoyServiceApiClient;
import com.huawei.appmarket.component.buoycircle.impl.storage.SharedInfoService;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;
import com.huawei.appmarket.component.buoycircle.impl.utils.WindowUtil;
import com.huawei.appmarket.component.buoycircle.impl.view.BuoyHideGuideDialog;
import com.huawei.appmarket.component.buoycircle.impl.view.FloatWindowBadge;
import com.huawei.appmarket.component.buoycircle.impl.view.FloatWindowBadgeParams;

public class FloatWindowSmallView
extends LinearLayout {
    private static final String TAG = "FloatWindowSmallView";
    private static final int AUTO_HIDE_DELAY = 2000;
    private WindowManager windowManager;
    private WindowManager.LayoutParams mParams;
    private float xInScreen;
    private float yInScreen;
    private float xDownInScreen;
    private float yDownInScreen;
    private float xInView;
    private float yInView;
    private int screenH;
    private int screenW;
    private View floatWindow = null;
    private ImageView halfHideView = null;
    private ImageView normalView = null;
    private Context mContext = null;
    private boolean isTouchMove = false;
    private Handler autoHideTimerHandler = null;
    private Runnable autoHideRunnable = null;
    private boolean isHalfHide = true;
    private boolean isReadyAutoHide = false;
    private AppInfo appInfo;
    private FloatWindowBadge redPointView;
    private int topBarHeight;
    private int orientation;
    private int currentPosition;
    private static final int VIEW_WIDTH_DP = 48;
    private static final int SMALL_VIEW_WIDTH_DP = 36;
    private static final int HIDE_VIEW_WIDTH_DP = 24;
    private static final int BADGE_WIDTH_DP = 6;
    private static final int SMALL_BADGE_MARGIN_X_DP = 30;
    private static final int SMALL_BADGE_MARGIN_Y_DP = 6;
    private static final int BADGE_MARGIN_DP = 0;
    private static final int SMALL_ALPHA = 153;
    BuoyAutoHideSensorManager.SensorCallback sensorCallbacks = new BuoyAutoHideSensorManager.SensorCallback(){

        @Override
        public void onReverseUp() {
            BuoyAnalyticHelper.getInstance().onReportOpenSmallBuoyBySensor(FloatWindowSmallView.this.mContext, FloatWindowSmallView.this.appInfo);
            if (BuoyHideCacheManager.getInstance().isAppHideBuoy(FloatWindowSmallView.this.mContext, FloatWindowSmallView.this.appInfo)) {
                BuoyHideCacheManager.getInstance().removeHideBuoyEvent(FloatWindowSmallView.this.mContext, FloatWindowSmallView.this.appInfo);
                FloatWindowSmallView.this.refreshVisible();
                FloatWindowSmallView.this.updateViewPosition(FloatWindowManager.getInstance().getXPosition(), FloatWindowManager.getInstance().getYPosition());
            }
            BuoyAutoHideSensorManager.getInstance().unRegisterSensor();
        }
    };

    public FloatWindowSmallView(Context context, AppInfo appInfo) {
        super(context);
        BuoyLog.d(TAG, "start create FloatWindowSmallView");
        this.windowManager = (WindowManager)context.getSystemService("window");
        LayoutInflater.from((Context)context).inflate(ResourceLoaderUtil.getLayoutId("c_buoycircle_window_small"), (ViewGroup)this);
        this.floatWindow = this.findViewById(ResourceLoaderUtil.getIdId("small_window_layout"));
        this.setCenterXY(context);
        this.mContext = context;
        this.halfHideView = (ImageView)this.findViewById(ResourceLoaderUtil.getIdId("half_hide_small_icon"));
        this.normalView = (ImageView)this.findViewById(ResourceLoaderUtil.getIdId("small_icon"));
        this.halfHideView.setImageAlpha(153);
        this.redPointView = new FloatWindowBadge(context);
        FloatWindowBadgeParams badgeParams = new FloatWindowBadgeParams();
        badgeParams.initParams(6, 6, 0, 0, 0, 0);
        this.redPointView.init(badgeParams);
        this.redPointView.setTargetView(this.floatWindow);
        this.orientation = context.getResources().getConfiguration().orientation;
        this.topBarHeight = WindowUtil.getStatusBarHeight(context);
        this.appInfo = appInfo;
        BuoyLog.d(TAG, "finish create FloatWindowSmallView");
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getContext() == null) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.xInView = event.getX();
                this.yInView = event.getY();
                this.xDownInScreen = event.getRawX();
                this.yDownInScreen = event.getRawY() - (float)this.topBarHeight;
                this.xInScreen = event.getRawX();
                this.yInScreen = event.getRawY() - (float)this.topBarHeight;
                this.isTouchMove = false;
                this.removeAutoHideListener();
                break;
            }
            case 2: {
                this.xInScreen = event.getRawX();
                this.yInScreen = event.getRawY() - (float)this.topBarHeight;
                this.updateViewPosition();
                if (!this.isTouchMove && this.checkTouchMoved()) {
                    this.isTouchMove = true;
                    this.removeAutoHideListener();
                    this.hideSmallView(false);
                    BuoyAutoHideNoticeManager.getInstance().showNotice();
                }
                if (!this.isTouchMove) break;
                if (BuoyAutoHideNoticeManager.getInstance().isMoveOnNotice(this.mParams.x, this.mParams.y)) {
                    BuoyAutoHideNoticeManager.getInstance().showNoticeBackground(true);
                    this.isReadyAutoHide = true;
                    break;
                }
                BuoyAutoHideNoticeManager.getInstance().showNoticeBackground(false);
                this.isReadyAutoHide = false;
                break;
            }
            case 1: {
                float upX = event.getRawX();
                float upY = event.getRawY();
                if (!this.isTouchMove) {
                    this.updateViewPosition(FloatWindowManager.getInstance().getXPosition(), FloatWindowManager.getInstance().getYPosition());
                    this.addAutoHideListener();
                    this.processClickEvent(event);
                } else {
                    this.processUpEvent(event, upX, upY);
                }
                this.isTouchMove = false;
                break;
            }
        }
        return true;
    }

    private void processUpEvent(MotionEvent event, float upX, float upY) {
        BuoyAutoHideNoticeManager.getInstance().hideNotice();
        if (this.isReadyAutoHide) {
            this.setVisibility(4);
            if (BuoyAutoHideNoticeManager.getInstance().isNeedShowGuideDialog(this.mContext)) {
                this.OpenBuoyHideDialog(this.mContext);
            } else {
                BuoyHideCacheManager.getInstance().saveHideBuoyEvent(this.mContext, this.appInfo, 2);
                BuoyAnalyticHelper.getInstance().onReportHideSmallBuoy(this.getContext(), this.appInfo);
            }
            if (BuoyAutoHideSensorManager.getInstance().isSupportSensor(this.getContext())) {
                BuoyAutoHideSensorManager.getInstance().registerSensor(this.sensorCallbacks);
            }
        } else {
            this.updateViewPosition(upX, upY, event.getX(), event.getY());
            this.addAutoHideListener();
        }
    }

    private void setCenterXY(Context context) {
        this.screenH = WindowUtil.getScreenH(context);
        this.screenW = WindowUtil.getTotalWidth(context);
    }

    private void setParams(WindowManager.LayoutParams params) {
        this.mParams = params;
        this.refreshTopBarHeight();
    }

    private void refreshTopBarHeight() {
        if (BuoyCutoutHelper.getInstance().isCutoutPortScreen(this.mContext)) {
            if (this.mContext instanceof Activity) {
                if (!BuoyCutoutHelper.getInstance().isActivityUseNotchArea((Activity)this.mContext)) {
                    this.topBarHeight = BuoyCutoutHelper.getInstance().getCutoutHeight(this.mContext);
                }
            } else {
                this.topBarHeight = WindowUtil.isOverStatus(this.mParams) ? 0 : this.topBarHeight;
            }
        } else {
            this.topBarHeight = WindowUtil.isOverStatus(this.mParams) ? 0 : this.topBarHeight;
        }
    }

    public int getTopBarHeight() {
        return this.topBarHeight;
    }

    private void updateViewPosition() {
        if (this.mParams == null) {
            return;
        }
        this.mParams.x = (int)(this.xInScreen - this.xInView);
        this.mParams.y = (int)(this.yInScreen - this.yInView);
        this.updateViewLayoutPosition();
    }

    private void updateViewPosition(int x2, int y2) {
        if (this.mParams == null) {
            return;
        }
        this.mParams.x = x2;
        this.mParams.y = y2;
        if (BuoyCutoutHelper.getInstance().hasNotchInScreen(this.mContext) && this.isNeedReSetPosition()) {
            this.setCutoutLayout();
        }
        this.updateViewLayoutPosition();
    }

    private void updateViewPosition(float upX, float upY, float x2, float y2) {
        this.setPositionByRule(upX, upY, x2, y2);
        if (BuoyCutoutHelper.getInstance().hasNotchInScreen(this.mContext) && this.isNeedReSetPosition()) {
            this.setCutoutLayout();
        }
        SharedInfoService util = SharedInfoService.getInstance(this.getContext());
        float positionYPercent = (float)(this.mParams.y + this.topBarHeight) / (float)this.screenH;
        util.setPositionYPercent(positionYPercent);
        float positionXPercent = (float)this.mParams.x / (float)this.screenW;
        util.setPositionXPercent(positionXPercent);
        this.updateViewLayoutPosition();
    }

    private boolean isNeedReSetPosition() {
        if (this.mContext != null) {
            String packageName;
            String string = packageName = this.appInfo != null ? this.appInfo.getPackageName() : "";
            if (!BuoyCutoutHelper.getInstance().isAdaptNotchArea(this.mContext, packageName)) {
                return false;
            }
            int orientation = this.mContext.getResources().getConfiguration().orientation;
            if (orientation == 2 && (this.mParams.x == 0 || this.mParams.x == this.screenW)) {
                return true;
            }
            if (orientation == 1 && (this.mParams.y == 0 || this.mParams.y == this.screenH)) {
                return true;
            }
        }
        return false;
    }

    public void setCutoutLayout() {
        BuoyLog.i(TAG, "set small view cutout position");
        CutoutInfo cutoutInfo = BuoyCutoutHelper.getInstance().getCutoutInfo(this.mContext);
        if (cutoutInfo != null && cutoutInfo.getRect() != null) {
            int viewHight = (int)WindowUtil.dp2px(this.mContext, 48);
            if (cutoutInfo.getOrientation() == 2) {
                Rect rect = cutoutInfo.getRect();
                int cutoutYCenter = (rect.bottom - rect.top) / 2 + rect.top;
                int viewYCenter = viewHight / 2 + this.mParams.y + this.topBarHeight;
                int viewTop = this.mParams.y + this.topBarHeight;
                int viewBottom = viewTop + viewHight + this.topBarHeight;
                if (viewBottom >= rect.top && viewYCenter <= cutoutYCenter) {
                    this.mParams.y = rect.top - viewHight - this.topBarHeight;
                } else if (viewYCenter >= cutoutYCenter && viewTop <= rect.bottom) {
                    this.mParams.y = rect.bottom - this.topBarHeight;
                }
            } else if (cutoutInfo.getOrientation() == 1) {
                Rect rect = cutoutInfo.getRect();
                int cutoutXCenter = (rect.right - rect.left) / 2 + rect.left;
                int viewXCenter = viewHight / 2 + this.mParams.x;
                int viewLeft = this.mParams.x;
                int viewRight = viewLeft + viewHight;
                if (viewRight >= rect.left && viewXCenter <= cutoutXCenter) {
                    this.mParams.x = rect.left - viewHight;
                } else if (viewXCenter >= cutoutXCenter && viewLeft <= rect.right) {
                    this.mParams.x = rect.right;
                }
            }
        }
    }

    private void setPositionByRule(float upX, float upY, float x2, float y2) {
        float mX = upX - x2;
        float mY = upY - (float)this.topBarHeight - y2;
        float leftDistance = upX;
        float rightDiatance = (float)this.screenW - upX;
        float upDistance = upY;
        float downDistance = (float)(this.screenH - this.topBarHeight) - upY;
        BuoyLog.d(TAG, "left:" + leftDistance + ",right:" + rightDiatance + ",up:" + upDistance + ",down:" + downDistance);
        float[] distanceArray = new float[]{leftDistance, upDistance, rightDiatance, downDistance};
        float min = distanceArray[0];
        this.currentPosition = 0;
        for (int i2 = 0; i2 < distanceArray.length; ++i2) {
            if (!(distanceArray[i2] < min)) continue;
            min = distanceArray[i2];
            this.currentPosition = i2;
        }
        switch (this.currentPosition) {
            case 0: {
                mX = 0.0f;
                break;
            }
            case 1: {
                mY = 0.0f;
                break;
            }
            case 2: {
                mX = this.screenW;
                break;
            }
            case 3: {
                mY = this.screenH;
                break;
            }
            default: {
                mX = 0.0f;
            }
        }
        this.mParams.x = (int)mX;
        this.mParams.y = (int)mY;
        this.setBadgePosition();
    }

    private void hideViewByRule() {
        float hideWidth = WindowUtil.dp2px(this.mContext, 24);
        FloatWindowBadgeParams badgeParams = new FloatWindowBadgeParams();
        BuoyLog.d(TAG, "hideViewByRule, currentPosition:" + this.currentPosition + ",hideWidth:" + hideWidth);
        switch (this.currentPosition) {
            case 0: {
                this.floatWindow.setX(-1.0f * hideWidth);
                badgeParams.initParams(6, 6, 30, 30, 6, 6);
                this.redPointView.setBadgeLayoutParams(badgeParams);
                break;
            }
            case 1: {
                this.floatWindow.setY(-1.0f * hideWidth);
                badgeParams.initParams(6, 6, 6, 6, 30, 30);
                this.redPointView.setBadgeLayoutParams(badgeParams);
                break;
            }
            case 2: {
                this.floatWindow.setX(hideWidth);
                badgeParams.initParams(6, 6, 30, 30, 6, 6);
                this.redPointView.setBadgeLayoutParams(badgeParams);
                break;
            }
            case 3: {
                this.floatWindow.setY(hideWidth);
                badgeParams.initParams(6, 6, 6, 6, 30, 30);
                this.redPointView.setBadgeLayoutParams(badgeParams);
                break;
            }
        }
    }

    private void updateViewLayoutPosition() {
        try {
            this.windowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "updateViewLayoutPosition exception:" + e2);
        }
    }

    public void showRedPoint(boolean isShow) {
        BuoyLog.d(TAG, "showRedPoint:" + isShow);
        if (isShow) {
            this.redPointView.setVisibility(0);
        } else {
            this.redPointView.setVisibility(8);
        }
    }

    private void processClickEvent(MotionEvent event) {
        int screenOrientation;
        if (PackageManagerHelper.isBackground(this.mContext, this.appInfo.getPackageName())) {
            BuoyLog.w(TAG, "app is in background, not response click event");
            return;
        }
        BuoyAnalyticHelper.getInstance().onReportClickSmallBuoy(this.mContext, this.appInfo);
        int n2 = screenOrientation = this.mContext.getResources().getConfiguration().orientation == 2 ? 2 : 1;
        if ("com.huawei.gamebox".equals(BuoyServiceApiClient.getInstance().getTargetApp())) {
            FloatWindowManager.getInstance().openBigBuoy(this.mContext, screenOrientation);
        } else {
            PackageManagerHelper pkmHelper = new PackageManagerHelper(this.mContext);
            int hiappVersionCode = pkmHelper.getPackageVersionCode("com.huawei.appmarket");
            if (hiappVersionCode >= 90000000) {
                FloatWindowManager.getInstance().openBigBuoy(this.mContext, screenOrientation);
            } else {
                BuoyLog.i(TAG, "current hiapp version = " + hiappVersionCode + ", not suppport system buoy, start update hiapp");
                this.startBridgeActivityUpdateApp(this.mContext);
            }
        }
    }

    private void startBridgeActivityUpdateApp(Context context) {
        if (context == null) {
            return;
        }
        Intent intent = BuoyBridgeActivity.getIntentStartBridgeActivity(context, BuoyUpdateDelegate.class.getName());
        intent.addFlags(0x10000000);
        if (this.appInfo != null) {
            intent.putExtra("sdkVersionCode", this.appInfo.getSdkVersionCode());
        }
        context.startActivity(intent);
    }

    private void OpenBuoyHideDialog(Context context) {
        if (context == null) {
            return;
        }
        if (context.getPackageName().equals("com.huawei.gamebox")) {
            this.openHideDialog(context);
        } else {
            this.startBridgeActivityOpenHideDialog(context);
        }
    }

    private void openHideDialog(Context context) {
        boolean isSupportSensor = BuoyAutoHideSensorManager.getInstance().isSupportSensor(context);
        AlertDialog dialog = BuoyHideGuideDialog.getGuideDialog(context, this.appInfo, isSupportSensor);
        dialog.show();
    }

    private void startBridgeActivityOpenHideDialog(Context context) {
        Intent intent = BuoyBridgeActivity.getIntentStartBridgeActivity(context, BuoyHideDelegate.class.getName());
        intent.addFlags(0x10000000);
        intent.putExtra("appInfo", (Parcelable)this.appInfo);
        context.startActivity(intent);
    }

    private boolean checkTouchMoved() {
        float absPosition = WindowUtil.dp2px(this.mContext, 24);
        return !(Math.abs(this.xDownInScreen - this.xInScreen) <= absPosition) || !(Math.abs(this.yDownInScreen - this.yInScreen) <= absPosition);
    }

    public void init(WindowManager.LayoutParams params) {
        if (params == null) {
            return;
        }
        this.setParams(params);
        this.setPositionByRule(params.x, params.y, 0.0f, 0.0f);
        params.x = FloatWindowManager.getInstance().getXPosition();
        params.y = FloatWindowManager.getInstance().getYPosition();
        if (BuoyCutoutHelper.getInstance().hasNotchInScreen(this.mContext) && this.isNeedReSetPosition()) {
            this.setCutoutLayout();
        }
        this.halfHideView.setVisibility(0);
        this.normalView.setVisibility(8);
        this.isHalfHide = true;
        this.hideViewByRule();
        this.showRedPoint(false);
        FloatWindowManager.getInstance().getBuoyRedInfo(this.mContext);
    }

    private boolean hideSmallView(boolean isHideSmallView) {
        boolean isPreState = this.isHalfHide;
        if (isHideSmallView) {
            this.startRotateAnimation((View)this.normalView, new IAnimation(){

                @Override
                public void onFinish() {
                    FloatWindowSmallView.this.halfHide();
                }
            });
        } else {
            this.halfHideView.setVisibility(8);
            this.normalView.setVisibility(0);
            FloatWindowBadgeParams badgeParams = new FloatWindowBadgeParams();
            badgeParams.initParams(6, 6, 0, 0, 0, 0);
            this.redPointView.setBadgeLayoutParams(badgeParams);
            this.isHalfHide = false;
            this.floatWindow.setX(0.0f);
            this.floatWindow.setY(0.0f);
        }
        return isPreState == this.isHalfHide;
    }

    private void halfHide() {
        this.halfHideView.setVisibility(0);
        this.normalView.setVisibility(8);
        this.isHalfHide = true;
        this.hideViewByRule();
    }

    private void addAutoHideListener() {
        if (this.autoHideTimerHandler == null) {
            this.autoHideTimerHandler = new Handler();
        }
        if (this.autoHideRunnable == null) {
            this.autoHideRunnable = new Runnable(){

                @Override
                public void run() {
                    if (FloatWindowSmallView.this.halfHideView.getVisibility() == 8) {
                        FloatWindowSmallView.this.hideSmallView(true);
                    }
                }
            };
        }
        this.autoHideTimerHandler.postDelayed(this.autoHideRunnable, 2000L);
    }

    public void removeAutoHideListener() {
        if (this.autoHideTimerHandler != null && this.autoHideRunnable != null) {
            this.autoHideTimerHandler.removeCallbacks(this.autoHideRunnable);
        }
    }

    private void startRotateAnimation(View view, final IAnimation callback) {
        if (null == view) {
            return;
        }
        AnimationSet as = new AnimationSet(true);
        RotateAnimation ra = new RotateAnimation(0.0f, 359.0f, 1, 0.5f, 1, 0.5f);
        ra.setDuration(300L);
        FWSAnimationListener animationListener = new FWSAnimationListener(){

            @Override
            public void onAnimationEnd(Animation animation) {
                if (null != callback) {
                    callback.onFinish();
                }
            }
        };
        ra.setAnimationListener((Animation.AnimationListener)animationListener);
        as.addAnimation((Animation)ra);
        view.startAnimation((Animation)as);
    }

    private void setBadgePosition() {
        switch (this.currentPosition) {
            case 0: 
            case 3: {
                this.redPointView.setBadgeGravity(53);
                break;
            }
            case 1: {
                this.redPointView.setBadgeGravity(85);
                break;
            }
            case 2: {
                this.redPointView.setBadgeGravity(51);
                break;
            }
        }
    }

    public void refreshVisible() {
        BuoyLog.i(TAG, "refreshVisible:" + FloatWindowManager.getInstance().isRemoteViewShow());
        if (FloatWindowManager.getInstance().isRemoteViewShow() || BuoyHideCacheManager.getInstance().isAppHideBuoy(this.mContext, this.appInfo)) {
            if (this.getVisibility() != 4) {
                this.setVisibility(4);
            }
        } else if (this.getVisibility() != 0) {
            this.setVisibility(0);
            this.updateViewPosition(FloatWindowManager.getInstance().getXPosition(), FloatWindowManager.getInstance().getYPosition());
            this.halfHide();
            this.showRedPoint(false);
            FloatWindowManager.getInstance().getBuoyRedInfo(this.mContext);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.refreshTopBarHeight();
        if (this.orientation == newConfig.orientation) {
            return;
        }
        this.orientation = newConfig.orientation;
        this.setCenterXY(this.mContext);
        this.halfHide();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                FloatWindowSmallView.this.updateViewPosition(FloatWindowManager.getInstance().getXPosition(), FloatWindowManager.getInstance().getYPosition());
            }
        }, 200L);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        BuoyLog.i(TAG, "onWindowVisibilityChanged:" + visibility);
        if (visibility == 8) {
            BuoyLog.i(TAG, "onWindowVisibilityChanged, hideFloatWindow");
            BuoyAutoHideNoticeManager.getInstance().hideNotice();
            if (BuoyHideCacheManager.getInstance().isAppHideBuoy(this.mContext, this.appInfo)) {
                BuoyAutoHideSensorManager.getInstance().unRegisterSensor();
            }
            if (FloatWindowManager.getInstance().isRemoteViewShow()) {
                FloatWindowManager.getInstance().finishBigBuoy(this.mContext);
            }
        }
    }

    private static class FWSAnimationListener
    implements Animation.AnimationListener {
        private FWSAnimationListener() {
        }

        public void onAnimationEnd(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationStart(Animation animation) {
        }
    }

    private static interface Position {
        public static final int LEFT = 0;
        public static final int TOP = 1;
        public static final int RIGHT = 2;
        public static final int BOTTOM = 3;
    }

    private static interface IAnimation {
        public void onFinish();
    }
}

