/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import java.io.InputStream;

public class GifImageView
extends ImageView {
    private int image;
    private Movie movie;
    private long movieStart = 0L;
    private float mScale;

    public GifImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public GifImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.setLayerType(1, null);
        this.image = attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "src", 0);
        this.movie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.image));
    }

    protected void onDraw(Canvas canvas) {
        this.drawGifImage(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.movie != null) {
            int movieWidth = this.movie.width();
            int movieHeight = this.movie.height();
            int maximumWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            float scaleW = (float)movieWidth / (float)maximumWidth;
            this.mScale = 1.0f / scaleW;
            int measuredMovieWidth = maximumWidth;
            int measuredMovieHeight = (int)((float)movieHeight * this.mScale);
            this.setMeasuredDimension(measuredMovieWidth, measuredMovieHeight);
        } else {
            this.setMeasuredDimension(this.getSuggestedMinimumWidth(), this.getSuggestedMinimumHeight());
        }
    }

    private void drawGifImage(Canvas canvas) {
        long nowTime = SystemClock.currentThreadTimeMillis();
        if (this.movieStart == 0L) {
            this.movieStart = nowTime;
        }
        if (this.movie != null) {
            int duration = this.movie.duration();
            int relTime = (int)((nowTime - this.movieStart) % (long)duration);
            this.movie.setTime(relTime);
            canvas.save(1);
            canvas.scale(this.mScale, this.mScale);
            this.movie.draw(canvas, 0.0f, 0.0f);
            this.invalidate();
        }
    }
}

