/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hianalytics.process;

import com.huawei.hianalytics.g.b;
import com.huawei.hianalytics.util.f;
import java.util.Arrays;

public class HiAnalyticsLogConfig {
    private com.huawei.hianalytics.e.f logData = new com.huawei.hianalytics.e.f();

    private HiAnalyticsLogConfig(Builder builder) {
        this.setMinLogLevel(builder.minLogLevel);
        this.setFileMaxSize(builder.fileMaxSize);
        this.setFailedFileMaxSize(builder.failedFileMaxSize);
        this.setMcc(builder.mcc);
        this.setLogServerUrl(builder.logServerUrl);
        this.setThrowableInfo(builder.throwableInfo);
        this.setThrowableFlag(builder.throwableFlag);
        this.setLogIsEnableImei(builder.logIsEnableImei);
        this.setLogIsEnableUdid(builder.logIsEnableUdid);
        this.setLogIsEnableSN(builder.logIsEnableSN);
        this.setLogImei(builder.logImei);
        this.setLogUdid(builder.logUdid);
        this.setLogSN(builder.logSN);
    }

    com.huawei.hianalytics.e.f getLogData() {
        return this.logData;
    }

    private void setMinLogLevel(int n2) {
        if (3 <= n2 && n2 <= 6) {
            this.logData.a(n2);
        } else {
            b.c("HiAnalytics/logServer", "HiAnalyticsLogConfig.setMinLogLevel(): minLogLevel: " + n2 + " invalid. Replaced with default value");
            this.logData.a(4);
        }
    }

    private void setFileMaxSize(int n2) {
        int n3 = f.a(n2, 10, 3);
        this.logData.b(n3);
    }

    private void setFailedFileMaxSize(int n2) {
        int n3 = f.a(n2, 10, 5);
        this.logData.c(n3);
    }

    private void setMcc(String string) {
        String string2 = f.a(string, 999, 100);
        this.logData.a(string2);
    }

    private void setThrowableInfo(String[] stringArray) {
        if (stringArray != null) {
            if (Arrays.toString(stringArray).length() > 204800) {
                b.c("HiAnalytics/logServer", "The throwableInfo parameter is too long!");
                this.logData.a(new String[0]);
            } else {
                this.logData.a((String[])stringArray.clone());
            }
        } else {
            this.logData.a(new String[0]);
        }
    }

    private void setThrowableFlag(int n2) {
        if (n2 != 0 && n2 != 1) {
            b.b("HiAnalytics/logServer", "The throwableFlag is wrong. Set to default value.");
            this.logData.d(0);
        } else {
            this.logData.d(n2);
        }
    }

    private void setLogServerUrl(String string) {
        String string2 = f.a("logUrl", string, "(https://)[a-zA-Z0-9-_]+[\\.a-zA-Z0-9_-]*(\\.hicloud\\.com)(:(\\d){2,5})?(\\\\|\\/)?", "");
        if (string2.endsWith("/") || string2.endsWith("\\")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.logData.b(string2);
    }

    private void setLogIsEnableImei(boolean bl) {
        this.logData.a(bl);
    }

    private void setLogIsEnableUdid(boolean bl) {
        this.logData.b(bl);
    }

    private void setLogIsEnableSN(boolean bl) {
        this.logData.c(bl);
    }

    private void setLogImei(String string) {
        this.logData.c(string);
    }

    private void setLogUdid(String string) {
        this.logData.d(string);
    }

    private void setLogSN(String string) {
        this.logData.e(string);
    }

    public static final class Builder {
        private int minLogLevel;
        private int fileMaxSize = 3;
        private int failedFileMaxSize = 5;
        private String mcc;
        private String logServerUrl;
        private String[] throwableInfo = new String[0];
        private int throwableFlag = 0;
        private boolean logIsEnableImei;
        private boolean logIsEnableUdid;
        private boolean logIsEnableSN;
        private String logImei = "";
        private String logUdid = "";
        private String logSN = "";

        public Builder(int n2, String string, String string2) {
            this.minLogLevel = n2;
            this.mcc = string;
            this.logServerUrl = string2;
        }

        public Builder setFileMaxSize(int n2) {
            this.fileMaxSize = n2;
            return this;
        }

        public Builder setFailedFileMaxSize(int n2) {
            this.failedFileMaxSize = n2;
            return this;
        }

        public Builder setThrowableInfo(int n2, String[] stringArray) {
            this.throwableFlag = n2;
            this.throwableInfo = stringArray != null ? (String[])stringArray.clone() : new String[0];
            return this;
        }

        @Deprecated
        public Builder setLogEnableImei(boolean bl) {
            this.logIsEnableImei = bl;
            return this;
        }

        @Deprecated
        public Builder setLogEnableUdid(boolean bl) {
            this.logIsEnableUdid = bl;
            return this;
        }

        @Deprecated
        public Builder setLogEnableSN(boolean bl) {
            this.logIsEnableSN = bl;
            return this;
        }

        public Builder setLogImei(String string) {
            if (!f.a("logimei", string, 4096)) {
                string = "";
            }
            this.logImei = string;
            return this;
        }

        public Builder setLogUdid(String string) {
            if (!f.a("logudid", string, 4096)) {
                string = "";
            }
            this.logUdid = string;
            return this;
        }

        public Builder setLogSN(String string) {
            if (!f.a("logsn", string, 4096)) {
                string = "";
            }
            this.logSN = string;
            return this;
        }

        public HiAnalyticsLogConfig build() {
            return new HiAnalyticsLogConfig(this);
        }
    }
}

