/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.content.Context;
import com.huawei.hianalytics.v2.HiAnalytics;
import com.huawei.hianalytics.v2.HiAnalyticsConf;
import com.huawei.hms.api.Api;
import com.huawei.hms.api.CheckUpdatelistener;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.HuaweiApiClientImpl;
import com.huawei.hms.c.h;
import com.huawei.hms.c.j;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.SubAppInfo;
import com.huawei.hms.support.api.entity.auth.PermissionInfo;
import com.huawei.hms.support.api.entity.auth.Scope;
import com.huawei.hms.support.b.a;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class HuaweiApiClient
implements ApiClient {
    public abstract void connect(Activity var1);

    public abstract void disconnect();

    @Override
    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void setConnectionCallbacks(ConnectionCallbacks var1);

    public abstract void setConnectionFailedListener(OnConnectionFailedListener var1);

    public abstract boolean setSubAppInfo(SubAppInfo var1);

    public abstract void checkUpdate(Activity var1, CheckUpdatelistener var2);

    public abstract void onResume(Activity var1);

    public abstract void onPause(Activity var1);

    public abstract Activity getTopActivity();

    public static final class Builder {
        private final Context a;
        private final List<Scope> b = new ArrayList<Scope>();
        private final List<PermissionInfo> c = new ArrayList<PermissionInfo>();
        private final Map<Api<?>, Api.ApiOptions> d = new HashMap();
        private OnConnectionFailedListener e;
        private ConnectionCallbacks f;

        public Builder(Context context) throws NullPointerException {
            com.huawei.hms.c.a.a(context, "context must not be null.");
            this.a = context.getApplicationContext();
            h.a(this.a);
            boolean bl = HiAnalytics.getInitFlag();
            com.huawei.hms.support.log.a.b("HMS BI", "Builder->biInitFlag :" + bl);
            boolean bl2 = j.d(context);
            com.huawei.hms.support.log.a.b("HMS BI", "Builder->biSetting :" + bl2);
            if (!bl && !bl2) {
                HiAnalyticsConf.Builder builder = new HiAnalyticsConf.Builder(context);
                builder.setEnableImei(true).setEnableUDID(true).setEnableSN(true).setCollectURL(0, "https://metrics1.data.hicloud.com:6447").create();
            }
        }

        public HuaweiApiClient build() {
            this.addApi(new Api("Core.API"));
            HuaweiApiClientImpl huaweiApiClientImpl = new HuaweiApiClientImpl(this.a);
            huaweiApiClientImpl.setScopes(this.b);
            huaweiApiClientImpl.setPermissionInfos(this.c);
            huaweiApiClientImpl.setApiMap(this.d);
            huaweiApiClientImpl.setConnectionCallbacks(this.f);
            huaweiApiClientImpl.setConnectionFailedListener(this.e);
            return huaweiApiClientImpl;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks connectionCallbacks) {
            com.huawei.hms.c.a.a(connectionCallbacks, "listener must not be null.");
            this.f = connectionCallbacks;
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener onConnectionFailedListener) {
            com.huawei.hms.c.a.a(onConnectionFailedListener, "listener must not be null.");
            this.e = onConnectionFailedListener;
            return this;
        }

        public Builder addScope(Scope scope) {
            com.huawei.hms.c.a.a(scope, "scope must not be null.");
            this.b.add(scope);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.d.put(api, null);
            if ("HuaweiGame.API".equals(api.getApiName())) {
                com.huawei.hms.support.b.a.a().a(this.a.getApplicationContext(), "15060106", "|" + System.currentTimeMillis());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O o2) {
            com.huawei.hms.c.a.a(api, "Api must not be null");
            com.huawei.hms.c.a.a(o2, "Null options are not permitted for this Api");
            this.d.put(api, o2);
            if (api.getOptions() != null) {
                List<Scope> list = api.getOptions().getScopeList(o2);
                this.b.addAll(list);
                List<PermissionInfo> list2 = api.getOptions().getPermissionInfoList(o2);
                this.c.addAll(list2);
            }
            return this;
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;
        public static final int CAUSE_API_CLIENT_EXPIRED = 3;

        public void onConnected();

        public void onConnectionSuspended(int var1);
    }
}

