/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.push;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hms.support.api.ResolvePendingResult;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.PendingResult;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.entity.push.AgreementReq;
import com.huawei.hms.support.api.entity.push.AgreementResp;
import com.huawei.hms.support.api.entity.push.DeleteTokenReq;
import com.huawei.hms.support.api.entity.push.DeleteTokenResp;
import com.huawei.hms.support.api.entity.push.EnableNotifyReq;
import com.huawei.hms.support.api.entity.push.EnableNotifyResp;
import com.huawei.hms.support.api.entity.push.PushStateReq;
import com.huawei.hms.support.api.entity.push.PushStateResp;
import com.huawei.hms.support.api.entity.push.TokenReq;
import com.huawei.hms.support.api.push.GetTagResult;
import com.huawei.hms.support.api.push.GetTokenPendingResultImpl;
import com.huawei.hms.support.api.push.HandleTagsResult;
import com.huawei.hms.support.api.push.HuaweiPushApi;
import com.huawei.hms.support.api.push.PushException;
import com.huawei.hms.support.api.push.TokenResult;
import com.huawei.hms.support.api.push.b.a;
import com.huawei.hms.support.api.push.b.a.a.c;
import com.huawei.hms.support.api.push.b.a.b;
import com.huawei.hms.support.api.push.b.b.d;
import java.util.List;
import java.util.Map;

public class HuaweiPushApiImp
implements HuaweiPushApi {
    @Override
    public PendingResult<TokenResult> getToken(ApiClient apiClient) {
        Context context = apiClient.getContext();
        com.huawei.hms.support.log.a.b("HuaweiPushApiImp", "get token, pkgName:" + context.getPackageName());
        c c2 = new c(context, "push_client_self_info");
        TokenReq tokenReq = new TokenReq();
        tokenReq.setPackageName(apiClient.getPackageName());
        if (!c2.a("hasRequestAgreement")) {
            tokenReq.setFirstTime(true);
            c2.a("hasRequestAgreement", true);
        } else {
            tokenReq.setFirstTime(false);
        }
        return new GetTokenPendingResultImpl(apiClient, "push.gettoken", tokenReq);
    }

    @Override
    public void deleteToken(ApiClient apiClient, String string) throws PushException {
        Context context = apiClient.getContext();
        com.huawei.hms.support.log.a.b("HuaweiPushApiImp", "invoke method: deleteToken, pkgName:" + context.getPackageName());
        if (TextUtils.isEmpty((CharSequence)string)) {
            com.huawei.hms.support.log.a.a("HuaweiPushApiImp", "token is null, can not deregister token");
            throw new PushException("push token invalid");
        }
        try {
            String string2 = b.a(context, "push_client_self_info");
            if (string.equals(string2)) {
                b.b(context, "push_client_self_info");
            }
            DeleteTokenReq deleteTokenReq = new DeleteTokenReq();
            deleteTokenReq.setPkgName(context.getPackageName());
            deleteTokenReq.setToken(string);
            ResolvePendingResult<DeleteTokenResp> resolvePendingResult = ResolvePendingResult.build(apiClient, "push.deletetoken", deleteTokenReq, DeleteTokenResp.class);
            resolvePendingResult.get();
            com.huawei.hms.support.api.push.b.a.a.a.a(apiClient, "push.deletetoken");
        }
        catch (Exception exception) {
            com.huawei.hms.support.log.a.a("HuaweiPushApiImp", "delete token failed, e=" + exception.getMessage());
            throw new PushException(exception + "delete token failed");
        }
    }

    @Override
    public PendingResult<HandleTagsResult> setTags(ApiClient apiClient, Map<String, String> map) throws PushException {
        return new com.huawei.hms.support.api.push.b().a(apiClient, map);
    }

    @Override
    public PendingResult<GetTagResult> getTags(ApiClient apiClient) throws PushException {
        return new com.huawei.hms.support.api.push.b().a(apiClient);
    }

    @Override
    public PendingResult<HandleTagsResult> deleteTags(ApiClient apiClient, List<String> list) throws PushException {
        return new com.huawei.hms.support.api.push.b().a(apiClient, list);
    }

    @Override
    public boolean getPushState(ApiClient apiClient) {
        PushStateReq pushStateReq = new PushStateReq();
        pushStateReq.setPkgName(apiClient.getPackageName());
        ResolvePendingResult<PushStateResp> resolvePendingResult = ResolvePendingResult.build(apiClient, "push.getpushstate", pushStateReq, PushStateResp.class);
        resolvePendingResult.get();
        com.huawei.hms.support.api.push.b.a.a.a.a(apiClient, "push.getpushstate");
        return true;
    }

    @Override
    public void enableReceiveNormalMsg(ApiClient apiClient, boolean bl) {
        com.huawei.hms.support.log.a.b("HuaweiPushApiImp", "invoke enableReceiveNormalMsg, set flag:" + bl);
        Context context = apiClient.getContext();
        c c2 = new c(context, "push_switch");
        c2.a("normal_msg_enable", !bl);
        com.huawei.hms.support.api.push.b.a.a.a.a(apiClient, "push.enableReceiveNormalMsg");
    }

    @Override
    public Status enableReceiveNotifyMsg(ApiClient apiClient, boolean bl) {
        com.huawei.hms.support.log.a.b("HuaweiPushApiImp", "invoke enableReceiveNotifyMsg, set flag:" + bl);
        Context context = apiClient.getContext();
        if (!a.a(context)) {
            if (!apiClient.isConnected()) {
                return new Status(907135003);
            }
            EnableNotifyReq enableNotifyReq = new EnableNotifyReq();
            enableNotifyReq.setPackageName(apiClient.getPackageName());
            enableNotifyReq.setEnable(bl);
            ResolvePendingResult<EnableNotifyResp> resolvePendingResult = ResolvePendingResult.build(apiClient, "push.setNotifyFlag", enableNotifyReq, EnableNotifyResp.class);
            resolvePendingResult.get();
        } else if (a.c(context) < 90101310L) {
            String string = d.a(context, context.getPackageName() + "#" + bl);
            Intent intent = new Intent("com.huawei.intent.action.SELF_SHOW_FLAG").putExtra("enalbeFlag", string);
            intent.setPackage("android");
            context.sendBroadcast(intent);
        } else {
            c c2 = new c(context, "push_notify_flag");
            c2.a("notify_msg_enable", !bl);
            Uri uri = Uri.parse((String)("content://" + context.getPackageName() + ".huawei.push.provider/" + "push_notify_flag" + ".xml"));
            Intent intent = new Intent("com.huawei.android.push.intent.SDK_COMMAND");
            intent.putExtra("type", "enalbeFlag");
            intent.putExtra("pkgName", apiClient.getPackageName());
            intent.putExtra("url", (Parcelable)uri);
            intent.setPackage("android");
            context.sendBroadcast(intent);
        }
        return Status.SUCCESS;
    }

    @Override
    public void queryAgreement(ApiClient apiClient) throws PushException {
        com.huawei.hms.support.log.a.b("HuaweiPushApiImp", "invoke queryAgreement");
        Context context = apiClient.getContext();
        AgreementReq agreementReq = new AgreementReq();
        agreementReq.setPkgName(context.getPackageName());
        String string = b.a(context, "push_client_self_info");
        c c2 = new c(context, "push_client_self_info");
        if (!c2.a("hasRequestAgreement")) {
            agreementReq.setFirstTime(true);
        } else {
            agreementReq.setFirstTime(false);
        }
        agreementReq.setToken(string);
        ResolvePendingResult<AgreementResp> resolvePendingResult = ResolvePendingResult.build(apiClient, "push.handleAgreement", agreementReq, AgreementResp.class);
        resolvePendingResult.get();
    }
}

