/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.updatesdk.fileprovider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.huawei.updatesdk.fileprovider.a;
import com.huawei.updatesdk.fileprovider.b;
import java.io.File;
import java.io.FileNotFoundException;

public class UpdateSdkFileProvider
extends ContentProvider {
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static a mWStrategy;
    private String authority;
    public static final String AUTHORITIES_SUFFIX = ".updateSdk.fileProvider";
    private static final String TAG = "UpdateSdkFileProvider";

    public boolean onCreate() {
        return true;
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        super.attachInfo(context, providerInfo);
        if (providerInfo.exported) {
            throw new SecurityException("WiseDist Provider must not be exported");
        }
        if (!providerInfo.grantUriPermissions) {
            throw new SecurityException("WiseDist Provider must grant uri permissions");
        }
        this.authority = providerInfo.authority;
        UpdateSdkFileProvider.createWiseDistPathStrategy(context, providerInfo.authority);
    }

    public static Uri getUriForFile(Context context, String string, File file) {
        UpdateSdkFileProvider.createWiseDistPathStrategy(context, string);
        return mWStrategy.a(file);
    }

    public Cursor query(Uri uri, String[] matrixCursor, String string, String[] stringArray, String string2) {
        File file = mWStrategy.a(uri);
        if (matrixCursor == null) {
            matrixCursor = COLUMNS;
        }
        String[] stringArray2 = new String[((String[])matrixCursor).length];
        Object[] objectArray = new Object[((String[])matrixCursor).length];
        int n2 = 0;
        for (String string3 : matrixCursor) {
            if ("_display_name".equals(string3)) {
                stringArray2[n2] = "_display_name";
                objectArray[n2++] = file.getName();
                continue;
            }
            if (!"_size".equals(string3)) continue;
            stringArray2[n2] = "_size";
            objectArray[n2++] = file.length();
        }
        stringArray2 = UpdateSdkFileProvider.copyOf(stringArray2, n2);
        objectArray = UpdateSdkFileProvider.copyOf(objectArray, n2);
        MatrixCursor matrixCursor2 = new MatrixCursor(stringArray2, 1);
        matrixCursor2.addRow(objectArray);
        return matrixCursor2;
    }

    private static String[] copyOf(String[] stringArray, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    private static Object[] copyOf(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    public String getType(Uri uri) {
        String string;
        if (null != uri && !TextUtils.isEmpty((CharSequence)uri.toString()) && uri.toString().endsWith("apk") && (string = MimeTypeMap.getSingleton().getMimeTypeFromExtension("apk")) != null) {
            return string;
        }
        return "application/octet-stream";
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public int update(Uri uri, ContentValues contentValues, String string, String[] stringArray) {
        throw new UnsupportedOperationException("No external updates");
    }

    public int delete(Uri uri, String string, String[] stringArray) {
        throw new UnsupportedOperationException("No external updates");
    }

    public ParcelFileDescriptor openFile(Uri uri, String string) throws FileNotFoundException {
        if (null == uri) {
            return null;
        }
        if (null == uri.getAuthority() || !uri.getAuthority().equals(this.authority)) {
            return null;
        }
        File file = mWStrategy.a(uri);
        if (!file.getName().endsWith("apk")) {
            com.huawei.updatesdk.sdk.a.c.a.a.a.d(TAG, "can not open this file.");
            return null;
        }
        int n2 = 0x10000000;
        return ParcelFileDescriptor.open((File)file, (int)0x10000000);
    }

    private static synchronized a createWiseDistPathStrategy(Context context, String string) {
        if (null == mWStrategy) {
            mWStrategy = new b(string);
            if (context.getFilesDir() != null) {
                File file = UpdateSdkFileProvider.buildPath(context.getFilesDir(), "/");
                mWStrategy.a("updatesdkapk", file);
            }
        }
        return mWStrategy;
    }

    private static File buildPath(File file, String ... stringArray) {
        File file2 = file;
        for (String string : stringArray) {
            if (string == null) continue;
            file2 = new File(file2, string);
        }
        return file2;
    }
}

