/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushServiceReceiver;
import com.xiaomi.xmpush.thrift.am;
import com.xiaomi.xmpush.thrift.u;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushMessageHelper {
    public static final String MESSAGE_TYPE = "message_type";
    public static final int MESSAGE_RAW = 1;
    public static final int MESSAGE_SENDMESSAGE = 2;
    public static final int MESSAGE_COMMAND = 3;
    public static final int MESSAGE_QUIT = 4;
    public static final int MESSAGE_ERROR = 5;
    public static final String ERROR_MESSAGE = "error_message";
    public static final String ERROR_TYPE = "error_type";
    public static final String ERROR_TYPE_NEED_PERMISSION = "error_lack_of_permission";
    public static final String KEY_MESSAGE = "key_message";
    public static final String KEY_COMMAND = "key_command";
    public static final int PUSH_MODE_CALLBACK = 1;
    public static final int PUSH_MODE_BROADCAST = 2;
    private static int pushMode = 0;

    private static boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        try {
            List list = packageManager.queryBroadcastReceivers(intent, 32);
            return list != null && !list.isEmpty();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static int getPushMode(Context context) {
        if (pushMode == 0) {
            if (PushMessageHelper.isUseCallbackPushMode(context)) {
                PushMessageHelper.setPushMode(1);
            } else {
                PushMessageHelper.setPushMode(2);
            }
        }
        return pushMode;
    }

    private static void setPushMode(int n2) {
        pushMode = n2;
    }

    public static boolean isUseCallbackPushMode(Context context) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setClassName(context.getPackageName(), "com.xiaomi.mipush.sdk.PushServiceReceiver");
        return PushMessageHelper.isIntentAvailable(context, intent);
    }

    public static void sendCommandMessageBroadcast(Context context, MiPushCommandMessage miPushCommandMessage) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setPackage(context.getPackageName());
        intent.putExtra(MESSAGE_TYPE, 3);
        intent.putExtra(KEY_COMMAND, (Serializable)miPushCommandMessage);
        new PushServiceReceiver().onReceive(context, intent);
    }

    public static void sendQuitMessageBroadcast(Context context) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setPackage(context.getPackageName());
        intent.putExtra(MESSAGE_TYPE, 4);
        new PushServiceReceiver().onReceive(context, intent);
    }

    public static MiPushCommandMessage generateCommandMessage(String string, List<String> list, long l2, String string2, String string3) {
        MiPushCommandMessage miPushCommandMessage = new MiPushCommandMessage();
        miPushCommandMessage.setCommand(string);
        miPushCommandMessage.setCommandArguments(list);
        miPushCommandMessage.setResultCode(l2);
        miPushCommandMessage.setReason(string2);
        miPushCommandMessage.setCategory(string3);
        return miPushCommandMessage;
    }

    public static MiPushMessage generateMessage(am am2, u u2, boolean bl2) {
        MiPushMessage miPushMessage = new MiPushMessage();
        miPushMessage.setMessageId(am2.c());
        if (!TextUtils.isEmpty((CharSequence)am2.j())) {
            miPushMessage.setMessageType(1);
            miPushMessage.setAlias(am2.j());
        } else if (!TextUtils.isEmpty((CharSequence)am2.h())) {
            miPushMessage.setMessageType(2);
            miPushMessage.setTopic(am2.h());
        } else if (!TextUtils.isEmpty((CharSequence)am2.r())) {
            miPushMessage.setMessageType(3);
            miPushMessage.setUserAccount(am2.r());
        } else {
            miPushMessage.setMessageType(0);
        }
        miPushMessage.setCategory(am2.p());
        if (am2.l() != null) {
            miPushMessage.setContent(am2.l().f());
        }
        if (u2 != null) {
            if (TextUtils.isEmpty((CharSequence)miPushMessage.getMessageId())) {
                miPushMessage.setMessageId(u2.b());
            }
            if (TextUtils.isEmpty((CharSequence)miPushMessage.getTopic())) {
                miPushMessage.setTopic(u2.f());
            }
            miPushMessage.setDescription(u2.j());
            miPushMessage.setTitle(u2.h());
            miPushMessage.setNotifyType(u2.l());
            miPushMessage.setNotifyId(u2.q());
            miPushMessage.setPassThrough(u2.o());
            miPushMessage.setExtra(u2.s());
        }
        miPushMessage.setNotified(bl2);
        return miPushMessage;
    }

    public static u generateMessage(MiPushMessage miPushMessage) {
        u u2 = new u();
        u2.a(miPushMessage.getMessageId());
        u2.b(miPushMessage.getTopic());
        u2.d(miPushMessage.getDescription());
        u2.c(miPushMessage.getTitle());
        u2.c(miPushMessage.getNotifyId());
        u2.a(miPushMessage.getNotifyType());
        u2.b(miPushMessage.getPassThrough());
        u2.a(miPushMessage.getExtra());
        return u2;
    }
}

