/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.bi;

import android.content.Context;
import com.huawei.appmarket.component.buoycircle.api.AppInfo;
import com.huawei.appmarket.component.buoycircle.api.IBuoyBIHandler;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.utils.NetworkUtil;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import com.huawei.appmarket.component.buoycircle.impl.utils.Util;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class BuoyAnalyticHelper {
    private static final String TAG = "BuoyAnalyticHelper";
    private IBuoyBIHandler buoyBIHandler;
    private static BuoyAnalyticHelper instance;

    private BuoyAnalyticHelper() {
    }

    public static synchronized BuoyAnalyticHelper getInstance() {
        if (instance == null) {
            instance = new BuoyAnalyticHelper();
        }
        return instance;
    }

    public void init(IBuoyBIHandler buoyBIHandler) {
        this.buoyBIHandler = buoyBIHandler;
    }

    private String getPlayerId(String appId) {
        if (this.buoyBIHandler != null) {
            return this.buoyBIHandler.getPlayerId(appId);
        }
        return null;
    }

    private Builder getBaseBuilder(String packageName, String appId, String sdkVersionCode) {
        return new Builder().startTag("01").playerId(this.getPlayerId(appId)).fromPkg(packageName).appId(appId).sdkVerCode(sdkVersionCode);
    }

    public void onReportShowBuoy(Context context, AppInfo appInfo) {
        if (!this.hasError(context, appInfo)) {
            boolean hasNetwork = NetworkUtil.hasActiveNetwork(context);
            Builder builder = this.getBaseBuilder(appInfo.getPackageName(), appInfo.getAppId(), appInfo.getSdkVersionCode()).hasNetwork(hasNetwork);
            this.onEventReport("15151012", builder.build());
        }
    }

    public void onReportClickSmallBuoy(Context context, AppInfo appInfo) {
        if (!this.hasError(context, appInfo)) {
            Builder builder = this.getBaseBuilder(appInfo.getPackageName(), appInfo.getAppId(), appInfo.getSdkVersionCode()).deviceModel(Util.getDeviceModel()).emuiVersion(Util.getBuildVersion());
            this.onEventReport("150106", builder.build());
        }
    }

    public void onReportOpenBigBuoyResult(Context context, AppInfo appInfo, int isSuccess) {
        if (!this.hasError(context, appInfo)) {
            boolean hasNetwork = NetworkUtil.hasActiveNetwork(context);
            Builder builder = this.getBaseBuilder(appInfo.getPackageName(), appInfo.getAppId(), appInfo.getSdkVersionCode()).deviceModel(Util.getDeviceModel()).emuiVersion(Util.getBuildVersion()).addTag(isSuccess).hasNetwork(hasNetwork);
            this.onEventReport("15150107", builder.build());
        }
    }

    public void onReportHideSmallBuoy(Context context, AppInfo appInfo) {
        if (!this.hasError(context, appInfo)) {
            Builder builder = this.getBaseBuilder(appInfo.getPackageName(), appInfo.getAppId(), appInfo.getSdkVersionCode());
            this.onEventReport("15150806", builder.build());
        }
    }

    public void onReportOpenSmallBuoyBySensor(Context context, AppInfo appInfo) {
        if (!this.hasError(context, appInfo)) {
            Builder builder = this.getBaseBuilder(appInfo.getPackageName(), appInfo.getAppId(), appInfo.getSdkVersionCode());
            this.onEventReport("15150906", builder.build());
        }
    }

    public void onReportUpdateHiAppResult(Context context, String updateAppName, String sdkVersionCode, String triggerApi, String result, int type) {
        if (context == null || this.buoyBIHandler == null) {
            BuoyLog.w(TAG, "onReportUpdateHiAppResult failed, params invalid");
            return;
        }
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        int targetVer = pmHelper.getPackageVersionCode(updateAppName);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("package", context.getPackageName());
        map.put("target_package", updateAppName);
        map.put("target_ver", String.valueOf(targetVer));
        map.put("sdk_ver", sdkVersionCode);
        map.put("app_id", Util.getMetaDataAppId(context));
        map.put("trigger_api", triggerApi);
        map.put("update_type", String.valueOf(type));
        map.put("net_type", String.valueOf(NetworkUtil.getNetworkType(context)));
        map.put("result", result);
        this.onEventReport("HMS_SDK_UPDATE", this.getReportJson(map));
    }

    private String getReportJson(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        JSONObject jsonObj = new JSONObject();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                jsonObj.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (JSONException e2) {
            BuoyLog.e(TAG, "AnalyticsHelper create json exception");
        }
        return jsonObj.toString();
    }

    private boolean hasError(Context context, AppInfo appInfo) {
        if (this.buoyBIHandler == null) {
            BuoyLog.w(TAG, "buoyBIHandler = null");
            return true;
        }
        if (appInfo == null) {
            BuoyLog.w(TAG, "appInfo = null");
            return true;
        }
        if (context == null) {
            BuoyLog.w(TAG, "context = null");
            return true;
        }
        return false;
    }

    private void onEventReport(String type, String content) {
        this.buoyBIHandler.onBIReport(type, content);
    }

    public static interface BUOY {
        public static final String NUMBER_01 = "01";
        public static final String SHOW_BUOY_KEY = "15151012";
        public static final String OPEN_BIG_KEY = "150106";
        public static final String OPEN_BIG_RESULT_KEY = "15150107";
        public static final String BUOY_HIDE_KEY = "15150806";
        public static final String BUOY_SENSOR_SHOW_KEY = "15150906";
        public static final String UPDATE_HIAPP_KEY = "HMS_SDK_UPDATE";
    }

    private static class Builder {
        private StringBuffer buffer = new StringBuffer();

        private Builder() {
        }

        Builder startTag(String tag) {
            this.buffer.append(tag);
            return this;
        }

        Builder playerId(String playerId) {
            return this.addTag(playerId);
        }

        Builder appId(String appId) {
            return this.addTag(appId);
        }

        Builder fromPkg(String packageName) {
            return this.addTag(packageName);
        }

        Builder sdkVerCode(String sdkVerCode) {
            return this.addTag(sdkVerCode);
        }

        Builder deviceModel(String deviceModel) {
            return this.addTag(deviceModel);
        }

        Builder hasNetwork(boolean hasNetwork) {
            if (hasNetwork) {
                return this.addTag("01");
            }
            return this.addTag("02");
        }

        Builder emuiVersion(String emuiVersion) {
            return this.addTag(emuiVersion);
        }

        Builder addTag(String tag) {
            if (tag == null) {
                tag = "";
            }
            this.buffer.append("|").append(tag);
            return this;
        }

        Builder addTag(int tag) {
            this.buffer.append("|").append(tag);
            return this;
        }

        String build() {
            return this.buffer.toString();
        }
    }
}

