/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.cutout;

import android.graphics.Rect;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import org.json.JSONException;
import org.json.JSONObject;

public class CutoutInfo {
    private static final String TAG = "CutoutInfo";
    private static final int NO_CUTOUT = 0;
    private int orientation;
    private int height;
    private Rect rect;

    public CutoutInfo(int height, int orientation, Rect rect) {
        this.height = height;
        this.orientation = orientation;
        this.rect = rect;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getHeight() {
        return this.height;
    }

    public Rect getRect() {
        return this.rect;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("orientation", this.orientation);
            jsonObject.put("height", this.height);
            if (this.rect != null) {
                jsonObject.put("left", this.rect.left);
                jsonObject.put("top", this.rect.top);
                jsonObject.put("right", this.rect.right);
                jsonObject.put("bottom", this.rect.bottom);
            }
        }
        catch (JSONException e2) {
            BuoyLog.e(TAG, "cutout info toJson meet exception");
        }
        return jsonObject;
    }

    public static CutoutInfo fromJson(String jsonText) {
        try {
            JSONObject jsonObject = new JSONObject(jsonText);
            int orientation = jsonObject.getInt("orientation");
            int height = jsonObject.getInt("height");
            Rect rect = new Rect();
            rect.left = jsonObject.getInt("left");
            rect.top = jsonObject.getInt("top");
            rect.right = jsonObject.getInt("right");
            rect.bottom = jsonObject.getInt("bottom");
            return new CutoutInfo(height, orientation, rect);
        }
        catch (JSONException e2) {
            BuoyLog.e(TAG, "cutout info fromJson meet exception");
            return null;
        }
    }

    public boolean isCutoutScreen() {
        return this.height != 0;
    }
}

