/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.delegete;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Window;
import com.huawei.appmarket.component.buoycircle.impl.cutout.BuoyCutoutHelper;
import com.huawei.appmarket.component.buoycircle.impl.delegete.IBridgeActivityDelegate;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.utils.ActivityUtil;
import com.huawei.appmarket.component.buoycircle.impl.utils.HwBuildEx;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BuoyBridgeActivity
extends Activity {
    public static final String EXTRA_DELEGATE_CLASS_NAME = "intent.extra.DELEGATE_CLASS_OBJECT";
    public static final String EXTRA_DELEGATE_UPDATE_INFO = "intent.extra.update.info";
    public static final String EXTRA_RESULT = "intent.extra.RESULT";
    public static final String EXTRA_IS_FULLSCREEN = "intent.extra.isfullscreen";
    private static final String TAG = "BuoyBridgeActivity";
    private IBridgeActivityDelegate mBridgeActivityDelegate;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestActivityTransparent();
        this.getWindow().setFlags(1024, 1024);
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        if (ResourceLoaderUtil.getmContext() == null) {
            ResourceLoaderUtil.setContext(this.getApplicationContext());
        }
        if (!this.initialize()) {
            this.setResult(1, null);
            this.finish();
        }
        BuoyCutoutHelper.getInstance().setLayoutInDisplayCutoutMode(this);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onBridgeActivityDestroy();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onBridgeConfigurationChanged();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean result;
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mBridgeActivityDelegate != null && !(result = this.mBridgeActivityDelegate.onBridgeActivityResult(requestCode, resultCode, data)) && !this.isFinishing()) {
            this.setResult(resultCode, data);
            this.finish();
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onKeyUp(keyCode, event);
        }
        return super.onKeyUp(keyCode, event);
    }

    public void finish() {
        BuoyLog.i(TAG, "Enter finish.");
        super.finish();
    }

    private void requestActivityTransparent() {
        int FLAG_TRANSLUCENT_STATUS = 0x4000000;
        this.requestWindowFeature(1);
        if (HwBuildEx.VERSION.EMUI_SDK_INT >= 9) {
            Window window = this.getWindow();
            window.addFlags(0x4000000);
            BuoyBridgeActivity.setHwFloating(window, true);
        }
    }

    private boolean initialize() {
        String className;
        Intent intent = this.getIntent();
        if (intent == null) {
            BuoyLog.e(TAG, "In initialize, Must not pass in a null intent.");
            return false;
        }
        if (intent.getBooleanExtra(EXTRA_IS_FULLSCREEN, false)) {
            this.getWindow().setFlags(1024, 1024);
        }
        if ((className = intent.getStringExtra(EXTRA_DELEGATE_CLASS_NAME)) == null) {
            BuoyLog.e(TAG, "In initialize, Must not pass in a null or non class object.");
            return false;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Class<IBridgeActivityDelegate> delegateClass = clazz.asSubclass(IBridgeActivityDelegate.class);
            this.mBridgeActivityDelegate = delegateClass.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
            BuoyLog.e(TAG, "In initialize, Failed to create 'IUpdateWizard' instance.");
            return false;
        }
        this.mBridgeActivityDelegate.onBridgeActivityCreate(this);
        return true;
    }

    private static void setHwFloating(Window window, boolean isHwFloating) {
        try {
            Method setHwFloatingMethod = window.getClass().getMethod("setHwFloating", Boolean.TYPE);
            setHwFloatingMethod.invoke((Object)window, isHwFloating);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e2) {
            BuoyLog.e(TAG, "In setHwFloating, Failed to call Window.setHwFloating().");
        }
    }

    public static Intent getIntentStartBridgeActivity(Activity parentActivity, String delegateName) {
        Intent intent = new Intent((Context)parentActivity, BuoyBridgeActivity.class);
        intent.putExtra(EXTRA_DELEGATE_CLASS_NAME, delegateName);
        intent.putExtra(EXTRA_IS_FULLSCREEN, ActivityUtil.isActivityFullscreen(parentActivity));
        return intent;
    }

    public static Intent getIntentStartBridgeActivity(Context parentActivity, String delegateName) {
        Intent intent = new Intent(parentActivity, BuoyBridgeActivity.class);
        intent.putExtra(EXTRA_DELEGATE_CLASS_NAME, delegateName);
        intent.putExtra(EXTRA_IS_FULLSCREEN, false);
        return intent;
    }
}

