/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.delegete;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import android.view.Window;
import com.huawei.appmarket.component.buoycircle.api.AppInfo;
import com.huawei.appmarket.component.buoycircle.impl.cutout.BuoyCutoutHelper;
import com.huawei.appmarket.component.buoycircle.impl.delegete.IBridgeActivityDelegate;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyAutoHideSensorManager;
import com.huawei.appmarket.component.buoycircle.impl.view.BuoyHideGuideDialog;
import java.lang.ref.WeakReference;

public class BuoyHideDelegate
implements IBridgeActivityDelegate {
    private WeakReference<Activity> mThisWeakRef;
    public static final String APP_INFO_KEY = "appInfo";
    private AlertDialog dialog = null;

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        this.mThisWeakRef = new WeakReference<Activity>(activity);
        boolean isSupportSensor = BuoyAutoHideSensorManager.getInstance().isSupportSensor((Context)activity);
        AppInfo appInfo = null;
        if (activity != null && activity.getIntent() != null) {
            Intent intent = activity.getIntent();
            appInfo = (AppInfo)intent.getParcelableExtra(APP_INFO_KEY);
        }
        this.dialog = BuoyHideGuideDialog.getGuideDialog((Context)activity, appInfo, isSupportSensor);
        if (this.dialog != null) {
            this.dialog.show();
            Window window = this.dialog.getWindow();
            if (window != null) {
                BuoyCutoutHelper.getInstance().setLayoutInDisplayCutoutMode(window.getAttributes());
            }
        }
    }

    @Override
    public void onBridgeActivityDestroy() {
        this.mThisWeakRef = null;
    }

    @Override
    public boolean onBridgeActivityResult(int requestCode, int resultCode, Intent data) {
        Activity activity = this.getActivity();
        if (activity == null) {
            return true;
        }
        activity.finish();
        return true;
    }

    @Override
    public void onBridgeConfigurationChanged() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            if (this.getActivity() != null) {
                Intent intent = this.getActivity().getIntent();
                AppInfo appInfo = null;
                if (intent != null) {
                    appInfo = (AppInfo)intent.getParcelableExtra(APP_INFO_KEY);
                }
                this.dialog = BuoyHideGuideDialog.getGuideDialog((Context)this.getActivity(), appInfo, BuoyAutoHideSensorManager.getInstance().isSupportSensor((Context)this.getActivity()));
                this.dialog.show();
            }
        }
    }

    @Override
    public int getRequestCode() {
        return 0;
    }

    @Override
    public void onKeyUp(int keyCode, KeyEvent event) {
    }

    private Activity getActivity() {
        if (this.mThisWeakRef == null) {
            return null;
        }
        return (Activity)this.mThisWeakRef.get();
    }
}

