/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.delegete;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import com.huawei.appmarket.component.buoycircle.impl.delegete.IBridgeActivityDelegate;
import com.huawei.appmarket.component.buoycircle.impl.manager.FloatWindowManager;
import com.huawei.appmarket.component.buoycircle.impl.update.manager.UpdateManager;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.UpdateBean;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;
import java.lang.ref.WeakReference;

public class BuoyUpdateDelegate
implements IBridgeActivityDelegate {
    private static final int REQUEST_CODE_UPDSTE_APP_MARKET = 1000;
    public static final String EXTRA_RESULT = "intent.extra.RESULT";
    private static final int SUCCESS = 0;
    public static final String SDK_VERSION_CODE = "sdkVersionCode";
    private WeakReference<Activity> mThisWeakRef;

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        this.mThisWeakRef = new WeakReference<Activity>(activity);
        UpdateBean bean = new UpdateBean();
        bean.setHmsOrApkUpgrade(true);
        bean.setClientPackageName("com.huawei.appmarket");
        bean.setClientVersionCode(90000000);
        bean.setClientAppId("C1027162");
        bean.setClientAppName(ResourceLoaderUtil.getString("c_buoycircle_appmarket_name"));
        String sdkVersionCode = null;
        if (activity != null && activity.getIntent() != null) {
            Intent intent = activity.getIntent();
            sdkVersionCode = intent.getStringExtra(SDK_VERSION_CODE);
        }
        bean.setSdkVersionCode(sdkVersionCode);
        UpdateManager.startUpdate(activity, 1000, bean);
        FloatWindowManager.getInstance().refreshSmallWindow(false);
    }

    private Activity getActivity() {
        if (this.mThisWeakRef == null) {
            return null;
        }
        return (Activity)this.mThisWeakRef.get();
    }

    @Override
    public boolean onBridgeActivityResult(int requestCode, int resultCode, Intent data) {
        Activity activity = this.getActivity();
        if (activity == null) {
            return true;
        }
        if (requestCode == 1000) {
            if (resultCode == -1) {
                int result = data.getIntExtra(EXTRA_RESULT, 0);
                if (result == 0) {
                    this.openBigBuoy(activity);
                } else {
                    FloatWindowManager.getInstance().refreshSmallWindow(true);
                }
            } else if (resultCode == 0) {
                PackageManagerHelper pkmHelper = new PackageManagerHelper((Context)activity);
                if (pkmHelper.getPackageVersionCode("com.huawei.appmarket") >= 90000000) {
                    this.openBigBuoy(activity);
                } else {
                    FloatWindowManager.getInstance().refreshSmallWindow(true);
                }
            }
            activity.finish();
        }
        return true;
    }

    private void openBigBuoy(Activity activity) {
        int screentOrient = activity.getResources().getConfiguration().orientation == 2 ? 2 : 1;
        FloatWindowManager.getInstance().openBigBuoy((Context)activity, screentOrient);
    }

    @Override
    public void onBridgeConfigurationChanged() {
    }

    @Override
    public void onBridgeActivityDestroy() {
        this.mThisWeakRef = null;
    }

    @Override
    public int getRequestCode() {
        return 0;
    }

    @Override
    public void onKeyUp(int keyCode, KeyEvent event) {
    }
}

