/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.manager;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.huawei.appmarket.component.buoycircle.impl.cutout.BuoyCutoutHelper;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.manager.FloatWindowManager;
import com.huawei.appmarket.component.buoycircle.impl.storage.BuoyStorage;
import com.huawei.appmarket.component.buoycircle.impl.utils.WindowUtil;
import com.huawei.appmarket.component.buoycircle.impl.view.BuoyAutoHideNoticeView;

public class BuoyAutoHideNoticeManager {
    private static final String TAG = "BuoyAutoHideManager";
    private static BuoyAutoHideNoticeManager instance = new BuoyAutoHideNoticeManager();
    public static final String BUOY_HIDE_GUIDE_SP_VALUE = "nomind";
    private BuoyAutoHideNoticeView mView;
    private WindowManager.LayoutParams layoutParams;

    public static BuoyAutoHideNoticeManager getInstance() {
        return instance;
    }

    private WindowManager.LayoutParams getLayoutParams() {
        Context context = this.mView.getContext();
        this.layoutParams = !"com.huawei.hwid".equals(context.getPackageName()) && context instanceof Activity ? new WindowManager.LayoutParams(2, 8) : new WindowManager.LayoutParams(2038, 296);
        this.layoutParams.gravity = 48;
        this.layoutParams.width = -1;
        this.layoutParams.height = -2;
        this.layoutParams.format = -3;
        this.layoutParams.setTitle((CharSequence)"com.huawei.hms.game.circle");
        if (BuoyCutoutHelper.getInstance().hasNotchInScreen(context) && FloatWindowManager.getInstance().isAppAdaptNotchArea()) {
            BuoyCutoutHelper.getInstance().setLayoutInDisplayCutoutMode(this.layoutParams);
        }
        return this.layoutParams;
    }

    public void createNotice(Context context) {
        if (context == null) {
            BuoyLog.e(TAG, "showNotice error, activity is null!");
            return;
        }
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            BuoyLog.e(TAG, "showNotice error, activity is finishing!");
            return;
        }
        try {
            this.mView = new BuoyAutoHideNoticeView(context);
            WindowManager.LayoutParams layoutParams = this.getLayoutParams();
            this.mView.setVisibility(8);
            this.getWindowManager(context).addView((View)this.mView, (ViewGroup.LayoutParams)layoutParams);
            BuoyLog.d(TAG, "end showNotice");
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "createNotice hide notice meet exception");
            if (this.mView != null) {
                this.mView.setVisibility(8);
            }
            this.removeNotice(context);
        }
    }

    public void updateView(BuoyAutoHideNoticeView view) {
        if (view != null) {
            this.mView = view;
            this.layoutParams = this.getLayoutParams();
            this.updateViewLayout();
        }
    }

    private void updateViewLayout() {
        if (this.mView != null) {
            Context context = this.mView.getContext();
            if (BuoyCutoutHelper.getInstance().isCutoutPortScreen(context)) {
                if (context instanceof Activity) {
                    if (BuoyCutoutHelper.getInstance().isActivityUseNotchArea((Activity)context) && !WindowUtil.isShowStatusBar(context)) {
                        this.layoutParams.y = BuoyCutoutHelper.getInstance().getCutoutHeight(context);
                    }
                } else if (FloatWindowManager.getInstance().isAppAdaptNotchArea()) {
                    this.layoutParams.y = BuoyCutoutHelper.getInstance().getCutoutHeight(context);
                }
            } else {
                this.layoutParams.y = 0;
            }
            this.getWindowManager(context).updateViewLayout((View)this.mView, (ViewGroup.LayoutParams)this.layoutParams);
        }
    }

    public void showNotice() {
        if (this.mView != null) {
            this.updateViewLayout();
            this.mView.setVisibility(0);
        }
    }

    public void hideNotice() {
        if (this.mView != null) {
            this.mView.setVisibility(8);
        }
    }

    private WindowManager getWindowManager(Context context) {
        return (WindowManager)context.getSystemService("window");
    }

    public void removeNotice(Context context) {
        if (context == null) {
            BuoyLog.e(TAG, "hideNotice error, activity is null!");
            return;
        }
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            BuoyLog.e(TAG, "hideNotice error, activity is finishing!");
            this.mView = null;
            return;
        }
        if (this.mView != null) {
            try {
                this.getWindowManager(context).removeView((View)this.mView);
            }
            catch (Exception e2) {
                BuoyLog.e(TAG, "removeNotice meet exception");
            }
            finally {
                this.mView = null;
            }
        }
    }

    public boolean isMoveOnNotice(float xInScreen, float yInScreen) {
        if (this.mView != null) {
            Context context = this.mView.getContext();
            int[] location = new int[2];
            if (context instanceof Activity && (WindowUtil.isShowStatusBar(context) || !BuoyCutoutHelper.getInstance().isActivityUseNotchArea((Activity)context))) {
                this.mView.getNoticeView().getLocationInWindow(location);
            } else {
                this.mView.getNoticeView().getLocationOnScreen(location);
            }
            int viewLeft = location[0];
            int viewTop = location[1];
            int viewRight = viewLeft + this.mView.getNoticeView().getWidth();
            int viewBottom = viewTop + this.mView.getNoticeView().getHeight();
            if (xInScreen >= (float)viewLeft && xInScreen <= (float)viewRight && yInScreen <= (float)viewBottom) {
                return true;
            }
        }
        return false;
    }

    public void showNoticeBackground(boolean isShowBackground) {
        if (this.mView != null) {
            this.mView.setShowBackground(isShowBackground);
        }
    }

    public boolean isNeedShowGuideDialog(Context context) {
        return !BUOY_HIDE_GUIDE_SP_VALUE.equals(BuoyStorage.getInstance().getHideGuideRecord(context));
    }
}

