/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.manager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;

public class BuoyAutoHideSensorManager {
    private static final String TAG = "BuoyAutoHideManager";
    private static BuoyAutoHideSensorManager instance = new BuoyAutoHideSensorManager();
    private static final float CRITICAL_DOWN_ANGLE = -9.8f;
    private static final float CRITICAL_UP_ANGLE = 9.8f;
    private static final long TIME_REVERSE_MAX = 3000L;
    private SensorManager mSensorManager;
    private Sensor mGsensor;
    private SensorCallback mSensorCallback;
    private int mReverseDownFlg = -1;
    private long timeStartReverse = 0L;
    private volatile boolean isScreenOn = true;
    private ScreenOnReceiver mScreenOnReceiver;
    private Context mContext;
    private SensorEventListener mGsensorListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent sensorEvent) {
            BuoyLog.d(BuoyAutoHideSensorManager.TAG, "Received onSensorChanged Message");
            if (sensorEvent.values[2] <= -9.8f && BuoyAutoHideSensorManager.this.mReverseDownFlg < 0) {
                BuoyAutoHideSensorManager.this.mReverseDownFlg = 0;
                BuoyAutoHideSensorManager.this.timeStartReverse = System.currentTimeMillis();
            } else if (sensorEvent.values[2] >= 9.8f && BuoyAutoHideSensorManager.this.mReverseDownFlg == 0) {
                BuoyAutoHideSensorManager.this.mReverseDownFlg = -1;
                if (System.currentTimeMillis() - BuoyAutoHideSensorManager.this.timeStartReverse > 3000L) {
                    BuoyLog.i(BuoyAutoHideSensorManager.TAG, "Reverse time more than 3s.");
                    return;
                }
                BuoyLog.i(BuoyAutoHideSensorManager.TAG, "mSensorCallback onSensorChanged");
                if (BuoyAutoHideSensorManager.this.mSensorCallback != null && BuoyAutoHideSensorManager.this.isScreenOn) {
                    BuoyAutoHideSensorManager.this.mSensorCallback.onReverseUp();
                    BuoyLog.i(BuoyAutoHideSensorManager.TAG, "mSensorCallback onReverseUp");
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int i2) {
        }
    };

    public static BuoyAutoHideSensorManager getInstance() {
        return instance;
    }

    public boolean isSupportSensor(Context context) {
        if (context == null) {
            return false;
        }
        this.mContext = context;
        if (this.mGsensor == null) {
            this.mSensorManager = (SensorManager)context.getSystemService("sensor");
            if (this.mSensorManager != null) {
                this.mGsensor = this.mSensorManager.getDefaultSensor(1);
            }
        }
        BuoyLog.i(TAG, "isSupportSensor:" + (this.mGsensor != null));
        return this.mGsensor != null;
    }

    public void registerSensor(SensorCallback sensorCallback) {
        BuoyLog.i(TAG, "registerSensor");
        try {
            if (this.mSensorCallback == null) {
                if (this.mSensorManager != null && this.mGsensor != null) {
                    this.mSensorManager.registerListener(this.mGsensorListener, this.mGsensor, 1);
                    this.mSensorCallback = sensorCallback;
                    this.registerScreenOnOffReceiver();
                }
            } else {
                this.mSensorCallback = sensorCallback;
            }
        }
        catch (Exception e2) {
            BuoyLog.w(TAG, "registerSensor meet exception");
        }
    }

    public void unRegisterSensor() {
        BuoyLog.i(TAG, "unRegisterSensor");
        if (this.mSensorManager != null && this.mGsensor != null) {
            this.mSensorCallback = null;
            this.mSensorManager.unregisterListener(this.mGsensorListener, this.mGsensor);
            this.unRegisterScreenOnReceiver();
        }
    }

    private void registerScreenOnOffReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        this.mScreenOnReceiver = new ScreenOnReceiver();
        if (this.mContext != null) {
            this.mContext.registerReceiver((BroadcastReceiver)this.mScreenOnReceiver, filter);
        } else {
            BuoyLog.w(TAG, "registerScreenOnReceiver failed, mContext is null");
        }
    }

    private void unRegisterScreenOnReceiver() {
        if (this.mScreenOnReceiver != null && this.mContext != null) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mScreenOnReceiver);
                this.mScreenOnReceiver = null;
            }
            catch (Exception e2) {
                BuoyLog.w(TAG, "mScreenOnReceiver not register, unregister failed");
            }
        }
    }

    private class ScreenOnReceiver
    extends BroadcastReceiver {
        private ScreenOnReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Log.d((String)BuoyAutoHideSensorManager.TAG, (String)"ScreenOnReceiver");
            if (intent == null) {
                return;
            }
            if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                BuoyAutoHideSensorManager.this.isScreenOn = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                BuoyAutoHideSensorManager.this.isScreenOn = false;
            }
        }
    }

    public static interface SensorCallback {
        public void onReverseUp();
    }
}

