/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.manager;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.appmarket.component.buoycircle.api.AppInfo;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.storage.GamePreferences;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class BuoyHideCacheManager {
    private static final String TAG = "BuoyHideCacheManager";
    private static final String FILE_NAME_HIDE_EVENT = "buoyHideEvent";
    private static final String HIDE_APP_PID_KEY = "hide_pid_key";
    private static final String HIDE_APP_MODE_KEY = "hide_mode_key";
    private GamePreferences gamePreference;
    private static BuoyHideCacheManager instance;
    public static final int NOT_HIDE_MODE = 0;
    public static final int DEFAULY_HIDE_MODE = 1;
    public static final int HAND_HIDE_MODE = 2;

    public static synchronized BuoyHideCacheManager getInstance() {
        if (instance == null) {
            instance = new BuoyHideCacheManager();
        }
        return instance;
    }

    public void saveHideBuoyEvent(Context context, AppInfo appInfo, int hideMode) {
        if (context == null || appInfo == null) {
            BuoyLog.w(TAG, "saveHideBuoyEvent, params invalid");
            return;
        }
        String packageName = appInfo.getPackageName();
        int pid = this.getPid(context, packageName);
        String key = this.getBuoyHideKey(appInfo);
        if (!TextUtils.isEmpty((CharSequence)key)) {
            try {
                JSONObject json = new JSONObject();
                json.put(HIDE_APP_PID_KEY, (Object)String.valueOf(pid));
                json.put(HIDE_APP_MODE_KEY, hideMode);
                this.getGamePreference(context).saveString(key, json.toString());
                BuoyLog.i(TAG, "saveHideBuoyEvent,packageName = " + packageName + ",appId = " + appInfo.getAppId());
            }
            catch (JSONException e2) {
                BuoyLog.w(TAG, "saveHideBuoyEvent,meet JSONException");
            }
        }
    }

    private String getBuoyHideKey(AppInfo appInfo) {
        if (appInfo != null) {
            return appInfo.getPackageName() + appInfo.getAppId();
        }
        return null;
    }

    public void removeHideBuoyEvent(Context context, AppInfo appInfo) {
        if (context == null || appInfo == null) {
            BuoyLog.i(TAG, "removeHideBuoyEvent failed,context=null?" + (context == null) + ",appInfo=null?" + (appInfo == null));
            return;
        }
        String key = this.getBuoyHideKey(appInfo);
        this.getGamePreference(context).remove(key);
    }

    public boolean isAppHideBuoy(Context context, AppInfo appInfo) {
        String key = this.getBuoyHideKey(appInfo);
        if (appInfo == null || context == null || TextUtils.isEmpty((CharSequence)key)) {
            BuoyLog.w(TAG, "context = " + context + ",BuoyHideKey = " + key);
            return false;
        }
        String hideEvent = this.getGamePreference(context).getString(key);
        if (!TextUtils.isEmpty((CharSequence)hideEvent)) {
            BuoyLog.w(TAG, "the app has hide event, app info = " + appInfo.toString());
            return true;
        }
        return false;
    }

    public boolean isAppRelaunch(Context context, AppInfo appInfo) {
        String hidePid;
        String key = this.getBuoyHideKey(appInfo);
        if (appInfo == null || context == null || TextUtils.isEmpty((CharSequence)key)) {
            BuoyLog.w(TAG, "context = " + context + ",BuoyHideKey = " + key);
            return false;
        }
        String jsonData = this.getGamePreference(context).getString(key);
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            hidePid = jsonObject.getString(HIDE_APP_PID_KEY);
        }
        catch (JSONException e2) {
            BuoyLog.i(TAG, "isAppRelaunch, meet exception");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)hidePid)) {
            BuoyLog.i(TAG, "not has hide event, return app not relaunch");
            return false;
        }
        String packageName = appInfo.getPackageName();
        String currentPid = String.valueOf(this.getPid(context, packageName));
        if (hidePid.equals(currentPid)) {
            BuoyLog.i(TAG, "has hide event, package name = " + packageName + ",cachePid=" + hidePid + ",currentPid" + currentPid);
            return false;
        }
        BuoyLog.i(TAG, "has hide event, package name = " + packageName + ",cachePid=" + hidePid + ",currentPid" + currentPid);
        return true;
    }

    private int getPid(Context context, String packageName) {
        return PackageManagerHelper.getPid(context, packageName);
    }

    public void clear(Context context) {
        if (context == null) {
            return;
        }
        this.getGamePreference(context).clear();
    }

    private GamePreferences getGamePreference(Context context) {
        if (this.gamePreference == null) {
            this.gamePreference = new GamePreferences(context, FILE_NAME_HIDE_EVENT);
        }
        return this.gamePreference;
    }

    public int getBuoyHideMode(Context context, String appId, String packageName) {
        int hideMode;
        String key = packageName + appId;
        if (context == null || TextUtils.isEmpty((CharSequence)key)) {
            BuoyLog.w(TAG, "context = " + context + ",BuoyHideKey = " + key);
            return 0;
        }
        String jsonData = this.getGamePreference(context).getString(key);
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            hideMode = jsonObject.getInt(HIDE_APP_MODE_KEY);
        }
        catch (JSONException e2) {
            BuoyLog.i(TAG, "isAppRelaunch, meet exception");
            hideMode = 0;
        }
        return hideMode;
    }
}

