/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.manager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import com.huawei.appmarket.component.buoycircle.api.AppInfo;
import com.huawei.appmarket.component.buoycircle.api.ISwitchGameAccountCallBack;
import com.huawei.appmarket.component.buoycircle.impl.bi.BuoyAnalyticHelper;
import com.huawei.appmarket.component.buoycircle.impl.cutout.BuoyCutoutDelegate;
import com.huawei.appmarket.component.buoycircle.impl.cutout.BuoyCutoutHelper;
import com.huawei.appmarket.component.buoycircle.impl.delegete.BuoyBridgeActivity;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyAutoHideNoticeManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyAutoHideSensorManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyHideCacheManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.MultiWindowAdapter;
import com.huawei.appmarket.component.buoycircle.impl.manager.SwitchGameSubAcctHandler;
import com.huawei.appmarket.component.buoycircle.impl.remote.BuoyServiceApiClient;
import com.huawei.appmarket.component.buoycircle.impl.remote.RemoteApiManager;
import com.huawei.appmarket.component.buoycircle.impl.remote.RunTask;
import com.huawei.appmarket.component.buoycircle.impl.remote.SequentialTaskManager;
import com.huawei.appmarket.component.buoycircle.impl.storage.SharedInfoService;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;
import com.huawei.appmarket.component.buoycircle.impl.utils.WindowUtil;
import com.huawei.appmarket.component.buoycircle.impl.view.FloatWindowSmallView;
import org.json.JSONException;
import org.json.JSONObject;

public class FloatWindowManager {
    private static final String TAG = "FloatWindowManager";
    private static final int SHOW_FLOAT_ON_UI_THREAD = 1001;
    private static final int REMOVE_FLOAT_ON_UI_THREAD = 1002;
    private FloatWindowSmallView smallWindow;
    private WindowManager.LayoutParams smallWindowParams;
    private final Object lock = new Object();
    private Handler msgHandler;
    protected Context mContext;
    private static FloatWindowManager instance;
    private boolean requestShowWindow = false;
    private static final int RTN_CODE_SHOW_BUOY_OK = 0;
    private static final int RTN_CODE_SHOW_BUOY_ERROR = 1;
    private static final int RTN_CODE_SHOW_BUOY_FINISH = 2;
    private static final int REFRESH_FLOAT_WINDOW_HANDLER = 1;
    private static final int REFRESH_RED_INFO_HANDLER = 2;
    private static final int SHOW_TOAST_CLICK_FAILED = 3;
    private static final int IS_NEED_RED_TRUE = 0;
    private static final int HAS_NEW_RED_MSG = 1;
    private boolean isRemoteViewShow = false;
    private int isNeedRed = -1;
    private String appId;
    private String cpId;
    private String packageName;
    private AppInfo appInfo;
    private ISwitchGameAccountCallBack mSwitchCallBack;
    private boolean isAppAdaptNotch;
    private int createMode;
    private static final int CRETAE_DEFAULT_DISPLAY = 0;
    private static final int CREATE_DEFAULT_HIDE = 1;
    private static final int CREATE_FORCE_DISPLAY = 2;
    private RunTask removeSmallBuoyTask = new RunTask(){

        @Override
        public void run() {
            Message msg = new Message();
            msg.what = 1;
            FloatWindowManager.this.getMsgHandler().sendMessage(msg);
        }
    };
    private RunTask onServiceDisconnectTask = new RunTask(){

        @Override
        public void run() {
            if (FloatWindowManager.getInstance().isRemoteViewShow()) {
                FloatWindowManager.getInstance().refreshSmallWindow(true);
            }
        }
    };
    private SequentialTaskManager.RunTaskResultHandler resultHandler = new SequentialTaskManager.RunTaskResultHandler(){

        @Override
        public void onResult(int result, String data) {
            if (data == null) {
                BuoyLog.e(FloatWindowManager.TAG, "getBuoyRedInfo resp is null");
                return;
            }
            BuoyLog.i(FloatWindowManager.TAG, "getBuoyRedInfo onResult result:" + result + ", data:" + data);
            FloatWindowManager.this.sendRedInfo(data);
        }
    };

    public static synchronized FloatWindowManager getInstance() {
        if (instance == null) {
            instance = new FloatWindowManager();
        }
        return instance;
    }

    private WindowManager.LayoutParams getLayoutParams() {
        WindowManager.LayoutParams layoutParams = !"com.huawei.hwid".equals(this.mContext.getPackageName()) && this.mContext instanceof Activity ? new WindowManager.LayoutParams(2, 8) : new WindowManager.LayoutParams(2038, 296);
        layoutParams.width = -2;
        layoutParams.height = -2;
        layoutParams.format = -3;
        layoutParams.gravity = 51;
        layoutParams.x = FloatWindowManager.getInstance().getXPosition();
        layoutParams.y = FloatWindowManager.getInstance().getYPosition();
        layoutParams.setTitle((CharSequence)"com.huawei.hms.game.circle");
        if (BuoyCutoutHelper.getInstance().hasSetOpenNotch(this.mContext) && BuoyCutoutHelper.getInstance().isAdaptNotchArea(this.mContext, this.appInfo.getPackageName())) {
            BuoyCutoutHelper.getInstance().setLayoutInDisplayCutoutMode(layoutParams);
            this.isAppAdaptNotch = true;
        }
        return layoutParams;
    }

    public boolean isAppAdaptNotchArea() {
        return this.isAppAdaptNotch;
    }

    protected void createSmallWindow(Context context, AppInfo appInfo, int createMode) {
        this.init(context, appInfo, createMode);
        this.createSmallWindow();
    }

    private void createSmallWindow() {
        this.setRequestShow(true);
        if (this.mContext == null || this.appInfo == null) {
            BuoyLog.w(TAG, "mContext = " + this.mContext + ",appInfo is null?" + (this.appInfo == null));
            return;
        }
        if (MultiWindowAdapter.getInstance().isInMultiWindowMode()) {
            BuoyLog.e(TAG, "current window is on multi window state");
            return;
        }
        if (PackageManagerHelper.isBackground(this.mContext, this.appInfo.getPackageName())) {
            BuoyLog.e(TAG, "app in background not show buoy");
            return;
        }
        FloatWindowManager.getInstance().registerMultiWindowListener();
        int hideMode = BuoyHideCacheManager.getInstance().getBuoyHideMode(this.mContext, this.appInfo.getAppId(), this.appInfo.getPackageName());
        BuoyLog.i(TAG, "createMode:" + this.createMode + ",currentHideMode:" + hideMode);
        if (this.createMode == 0 && hideMode == 1) {
            BuoyLog.i(TAG, "need to show buoy, remove hide event");
            BuoyHideCacheManager.getInstance().removeHideBuoyEvent(this.mContext, this.appInfo);
        }
        if (this.createMode == 1 && !BuoyHideCacheManager.getInstance().isAppHideBuoy(this.mContext, this.appInfo)) {
            BuoyLog.i(TAG, "need to default hide buoy, save default hide event");
            BuoyHideCacheManager.getInstance().saveHideBuoyEvent(this.mContext, this.appInfo, 1);
        }
        if (BuoyHideCacheManager.getInstance().isAppHideBuoy(this.mContext, this.appInfo)) {
            if (this.createMode == 2) {
                BuoyLog.i(TAG, "remove hide event, force show buoy");
                BuoyHideCacheManager.getInstance().removeHideBuoyEvent(this.mContext, this.appInfo);
                BuoyAutoHideSensorManager.getInstance().unRegisterSensor();
                this.startShowSmallWindow();
                return;
            }
            FloatWindowManager.getInstance().registerAutoHideSensorListener();
            if (hideMode == 2 && !BuoyHideCacheManager.getInstance().isAppRelaunch(this.mContext, this.appInfo)) {
                BuoyLog.d(TAG, "app not relaunch, continue hide buoy");
                return;
            }
            this.getBuoyHasNewRedInfo();
            return;
        }
        this.startShowSmallWindow();
    }

    private void getBuoyHasNewRedInfo() {
        RemoteApiManager.getInstance().getBuoyNewRedNotice(this.mContext, new SequentialTaskManager.RunTaskResultHandler(){

            @Override
            public void onResult(int result, String data) {
                if (data != null) {
                    try {
                        BuoyLog.i(FloatWindowManager.TAG, "getBuoyNewRedNotice result:" + result + ", data:" + data);
                        JSONObject jsonObj = new JSONObject(data);
                        int hasNewRedNotice = jsonObj.getInt("hasNewRedNotice");
                        if (1 == hasNewRedNotice) {
                            BuoyHideCacheManager.getInstance().removeHideBuoyEvent(FloatWindowManager.this.mContext, FloatWindowManager.this.appInfo);
                            BuoyAutoHideSensorManager.getInstance().unRegisterSensor();
                            FloatWindowManager.this.startShowSmallWindow();
                        }
                    }
                    catch (JSONException e2) {
                        BuoyLog.e(FloatWindowManager.TAG, "getBuoyRed new message meet JSONException");
                    }
                }
            }
        }, this.appId, this.cpId, this.packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSmallWindow() {
        BuoyLog.i(TAG, "start show small buoy window");
        WindowUtil.setStatusBarHeight(this.mContext);
        if (this.smallWindowParams == null) {
            this.smallWindowParams = this.getLayoutParams();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.smallWindow != null) {
                BuoyLog.i(TAG, "small buoy window has exist, refresh visible");
                Message msg = new Message();
                msg.what = 1;
                this.getMsgHandler().sendMessage(msg);
                return;
            }
            this.smallWindow = new FloatWindowSmallView(this.mContext, this.appInfo);
            this.smallWindow.init(this.smallWindowParams);
            this.smallWindow.refreshVisible();
            BuoyLog.d(TAG, "add small window:" + this.smallWindowParams.x + "," + this.smallWindowParams.y);
            Message msg = new Message();
            msg.what = 1001;
            this.getMsgHandler().sendMessage(msg);
            BuoyServiceApiClient.getInstance().registerHandler("finishBuoyDialog", new BuoyServiceApiClient.GameServiceApiHandler(){

                @Override
                public void onResult(int result, String data) {
                    FloatWindowManager.getInstance().onFinishBuoy(result, data);
                }
            });
            RemoteApiManager.getInstance().setOnServiceDisconnectTask(this.onServiceDisconnectTask);
            RemoteApiManager.getInstance().setRemoveSmallBuoyTask(this.removeSmallBuoyTask);
        }
    }

    private void addView() {
        try {
            if (this.smallWindow != null) {
                BuoyAutoHideNoticeManager.getInstance().createNotice(this.mContext);
                this.getWindowManager(this.mContext).addView((View)this.smallWindow, (ViewGroup.LayoutParams)this.smallWindowParams);
                BuoyAnalyticHelper.getInstance().onReportShowBuoy(this.mContext, this.appInfo);
                BuoyLog.i(TAG, "end addSmallWindow");
            } else {
                BuoyLog.e(TAG, "smallWindow is null when add view!");
            }
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "add small window exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSmallWindow() {
        BuoyLog.i(TAG, "start remove small buoy window");
        this.setRequestShow(false);
        if (this.mContext == null || this.appInfo == null) {
            BuoyLog.w(TAG, "mContext = " + this.mContext + ",appInfo is null?" + (this.appInfo == null));
            this.smallWindow = null;
            this.smallWindowParams = null;
            return;
        }
        if (BuoyHideCacheManager.getInstance().isAppHideBuoy(this.mContext, this.appInfo)) {
            BuoyAutoHideSensorManager.getInstance().unRegisterSensor();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.smallWindow != null) {
                Message msg = new Message();
                msg.what = 1002;
                this.getMsgHandler().sendMessage(msg);
            }
        }
    }

    private void removeView() {
        try {
            if (this.smallWindow != null) {
                WindowManager windowManager = this.getWindowManager(this.mContext);
                windowManager.removeView((View)this.smallWindow);
                BuoyAutoHideNoticeManager.getInstance().removeNotice(this.mContext);
                BuoyLog.i(TAG, "end removeBuoyCircle");
            }
        }
        catch (Exception e2) {
            BuoyLog.w(TAG, "remove smallWindow failed");
        }
        finally {
            this.smallWindow = null;
            this.smallWindowParams = null;
        }
    }

    private WindowManager getWindowManager(Context context) {
        return (WindowManager)context.getSystemService("window");
    }

    public boolean isRequestShow() {
        BuoyLog.d(TAG, "isRequestShow:" + this.requestShowWindow);
        return this.requestShowWindow;
    }

    private void setRequestShow(boolean requestShow) {
        BuoyLog.d(TAG, "setRequestShow:" + requestShow);
        this.requestShowWindow = requestShow;
    }

    private void init(Context context, AppInfo appInfo, int createMode) {
        this.mContext = context;
        this.createMode = createMode;
        String targetApp = "com.huawei.appmarket";
        if (this.mContext != null) {
            ResourceLoaderUtil.setContext(this.mContext);
            if ("com.huawei.gamebox".equals(this.mContext.getPackageName())) {
                targetApp = "com.huawei.gamebox";
            }
        }
        if (appInfo != null) {
            this.appId = appInfo.getAppId();
            this.cpId = appInfo.getCpId();
            this.packageName = appInfo.getPackageName();
            this.appInfo = appInfo;
        }
        BuoyServiceApiClient.getInstance().setTargetApp(targetApp);
        BuoyServiceApiClient.getInstance().setShowBuoyApp(this.packageName);
    }

    private void startShowSmallWindow() {
        if (!BuoyCutoutHelper.getInstance().hasSetOpenNotch(this.mContext) || BuoyCutoutHelper.getInstance().getCutoutInfo(this.mContext) != null) {
            this.showSmallWindow();
            return;
        }
        if (this.mContext instanceof Activity) {
            BuoyCutoutHelper.getInstance().getCutoutSize((Activity)this.mContext);
        } else {
            Intent intent = BuoyBridgeActivity.getIntentStartBridgeActivity(this.mContext, BuoyCutoutDelegate.class.getName());
            intent.addFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
    }

    private void showRedPoint() {
        if (this.smallWindow != null) {
            this.smallWindow.showRedPoint(this.isNeedRed == 0);
        }
    }

    private void setNeedRed(int isNeedRed) {
        this.isNeedRed = isNeedRed;
        this.showRedPoint();
    }

    public boolean isRemoteViewShow() {
        return this.isRemoteViewShow;
    }

    public void openBigBuoy(Context activity, int screentOrient) {
        RemoteApiManager.getInstance().showBuoyDialog(activity, new ShowBuoyHandler(), screentOrient, this.appId, this.cpId, this.packageName);
        RemoteApiManager.getInstance().switchGameSubAcct(new SwitchGameSubAcctHandler(this.mContext, this.mSwitchCallBack));
    }

    public void finishBigBuoy(Context context) {
        if (context == null) {
            BuoyLog.w(TAG, "finish big buoy, context is null");
            return;
        }
        RemoteApiManager.getInstance().finishBuoyDialog(context, new FinishBuoyHandler(), this.appId, this.cpId, this.packageName);
    }

    public void getBuoyRedInfo(Context context) {
        if (context == null) {
            BuoyLog.w(TAG, "get buoy red info, context is null");
            return;
        }
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        if ("com.huawei.gamebox".equals(context.getPackageName())) {
            BuoyLog.i(TAG, "small buoy is applied in gamebox h5");
            RemoteApiManager.getInstance().getBuoyRedInfo(context, this.resultHandler, this.appId, this.cpId, this.packageName);
            return;
        }
        if (pmHelper.getPackageVersionCode("com.huawei.appmarket") >= 90000000) {
            RemoteApiManager.getInstance().getBuoyRedInfo(context, this.resultHandler, this.appId, this.cpId, this.packageName);
        } else {
            FloatWindowManager.getInstance().setNeedRed(0);
        }
    }

    private void sendRedInfo(String data) {
        try {
            JSONObject jsonObj = new JSONObject(data);
            int isNeedRed = jsonObj.getInt("isNeedRed");
            BuoyLog.d(TAG, "getBuoyRedInfo isNeedRed:" + isNeedRed);
            FloatWindowManager.getInstance().isNeedRed = isNeedRed;
            Message msg = new Message();
            msg.what = 2;
            this.getMsgHandler().sendMessage(msg);
        }
        catch (JSONException e2) {
            BuoyLog.e(TAG, "getBuoyRedInfo resp JSONException");
        }
        catch (IllegalArgumentException e3) {
            BuoyLog.e(TAG, "getBuoyRedInfo resp IllegalArgumentException");
        }
    }

    public int getXPosition() {
        SharedInfoService util = SharedInfoService.getInstance(this.mContext);
        float sX = util.getPositionXPercent();
        if (sX > 0.0f) {
            return (int)(sX * (float)WindowUtil.getTotalWidth(this.mContext));
        }
        return WindowUtil.getDefaultPositionX(this.mContext);
    }

    public int getYPosition() {
        SharedInfoService util = SharedInfoService.getInstance(this.mContext);
        float sY = util.getPositionYPercent();
        if (sY >= 0.0f) {
            int y2 = (int)(sY * (float)WindowUtil.getScreenH(this.mContext));
            if (this.smallWindow != null) {
                return y2 - this.smallWindow.getTopBarHeight();
            }
            return y2;
        }
        return WindowUtil.getDefaultPositionY(this.mContext);
    }

    public void onFinishBuoy(int result, String data) {
        BuoyLog.i(TAG, "finishBigBuoy onResult result:" + result + ", data:" + data);
        if (result == 0 && !TextUtils.isEmpty((CharSequence)data)) {
            try {
                JSONObject json = new JSONObject(data);
                int rtnCode = json.getInt("retCode");
                Message msg = null;
                switch (rtnCode) {
                    case 0: {
                        BuoyServiceApiClient.getInstance().terminate();
                        break;
                    }
                    case 2: {
                        msg = new Message();
                        msg.what = 1;
                        this.getMsgHandler().sendMessage(msg);
                        this.isRemoteViewShow = false;
                        break;
                    }
                }
            }
            catch (JSONException e2) {
                BuoyLog.e(TAG, "finishBigBuoy onResult JSONException:");
            }
        }
    }

    public void registerAutoHideSensorListener() {
        BuoyLog.d(TAG, "smallWindow is auto hide");
        if (BuoyAutoHideSensorManager.getInstance().isSupportSensor(this.mContext)) {
            BuoyAutoHideSensorManager.getInstance().registerSensor(new BuoyAutoHideSensorManager.SensorCallback(){

                @Override
                public void onReverseUp() {
                    BuoyAnalyticHelper.getInstance().onReportOpenSmallBuoyBySensor(FloatWindowManager.this.mContext, FloatWindowManager.this.appInfo);
                    if (BuoyHideCacheManager.getInstance().isAppHideBuoy(FloatWindowManager.this.mContext, FloatWindowManager.this.appInfo)) {
                        BuoyHideCacheManager.getInstance().removeHideBuoyEvent(FloatWindowManager.this.mContext, FloatWindowManager.this.appInfo);
                        FloatWindowManager.getInstance().startShowSmallWindow();
                        BuoyLog.i(FloatWindowManager.TAG, "onReverseUp re-showBuoy success");
                    }
                    BuoyAutoHideSensorManager.getInstance().unRegisterSensor();
                }
            });
        }
    }

    private void registerMultiWindowListener() {
        if (!MultiWindowAdapter.getInstance().isSupportListenMultiWindowMode()) {
            BuoyLog.w(TAG, "register failed, not support multi window mode");
            return;
        }
        MultiWindowAdapter.getInstance().registerModeChangeListener(new MultiWindowAdapter.MultiWindowCallBack(){

            @Override
            public void startMultiWindow() {
                if (FloatWindowManager.getInstance().isRequestShow()) {
                    BuoyLog.i(FloatWindowManager.TAG, "start enter multi window , remove small window");
                    FloatWindowManager.getInstance().removeSmallWindow();
                    MultiWindowAdapter.getInstance().unRegisterModeChangeListener();
                }
            }

            @Override
            public void endMultiWindow() {
            }
        });
    }

    public void setSwitchGameAccountCallBack(ISwitchGameAccountCallBack callBack) {
        this.mSwitchCallBack = callBack;
    }

    public void refreshSmallWindow(boolean isShow) {
        this.resetStatus(!isShow);
        Message msg = new Message();
        msg.what = 1;
        this.getMsgHandler().sendMessage(msg);
    }

    private void resetStatus(boolean isRemoteViewShow) {
        this.isRemoteViewShow = isRemoteViewShow;
        this.isNeedRed = -1;
    }

    private Handler getMsgHandler() {
        if (this.msgHandler != null) {
            return this.msgHandler;
        }
        if (this.mContext == null) {
            BuoyLog.e(TAG, "mContext is null, getMsgHandler failed");
            return new Handler();
        }
        this.msgHandler = new Handler(this.mContext.getMainLooper()){

            public void handleMessage(Message msg) {
                BuoyLog.d(FloatWindowManager.TAG, "handleMessage:" + msg.what);
                if (1 == msg.what) {
                    if (FloatWindowManager.this.smallWindow != null) {
                        FloatWindowManager.this.smallWindow.removeAutoHideListener();
                        FloatWindowManager.this.smallWindow.refreshVisible();
                    }
                } else if (2 == msg.what) {
                    FloatWindowManager.this.showRedPoint();
                } else if (3 == msg.what) {
                    Toast.makeText((Context)FloatWindowManager.this.mContext, (int)ResourceLoaderUtil.getStringId("c_buoycircle_floatwindow_click_fail_toast"), (int)1).show();
                } else if (1001 == msg.what) {
                    FloatWindowManager.this.addView();
                } else if (1002 == msg.what) {
                    FloatWindowManager.this.removeView();
                }
            }
        };
        return this.msgHandler;
    }

    protected void performDestroy() {
        BuoyHideCacheManager.getInstance().clear(this.mContext);
    }

    private class ShowBuoyHandler
    implements SequentialTaskManager.RunTaskResultHandler {
        private ShowBuoyHandler() {
        }

        @Override
        public void onResult(int result, String data) {
            BuoyLog.i(FloatWindowManager.TAG, "showGameboxBuoyWindow onResult:" + result + ", data:" + data);
            if (result == 0 && !TextUtils.isEmpty((CharSequence)data)) {
                try {
                    JSONObject json = new JSONObject(data);
                    int rtnCode = json.getInt("retCode");
                    BuoyAnalyticHelper.getInstance().onReportOpenBigBuoyResult(FloatWindowManager.this.mContext, FloatWindowManager.this.appInfo, rtnCode);
                    switch (rtnCode) {
                        case 0: {
                            FloatWindowManager.this.isRemoteViewShow = true;
                            Message msg = new Message();
                            msg.what = 1;
                            FloatWindowManager.this.getMsgHandler().sendMessage(msg);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            FloatWindowManager.this.isRemoteViewShow = false;
                            Message msg = new Message();
                            msg.what = 1;
                            FloatWindowManager.this.getMsgHandler().sendMessage(msg);
                            break;
                        }
                    }
                }
                catch (JSONException e2) {
                    BuoyLog.e(FloatWindowManager.TAG, "showGameboxBuoyWindow onResult JSONException");
                }
            }
            if (result == 10) {
                BuoyLog.e(FloatWindowManager.TAG, "Bind higame failed.");
                if (FloatWindowManager.this.mContext != null) {
                    Message msg = new Message();
                    msg.what = 3;
                    FloatWindowManager.this.getMsgHandler().sendMessage(msg);
                }
            }
        }
    }

    private class FinishBuoyHandler
    implements SequentialTaskManager.RunTaskResultHandler {
        private FinishBuoyHandler() {
        }

        @Override
        public void onResult(int result, String data) {
            FloatWindowManager.this.onFinishBuoy(result, data);
        }
    }
}

