/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.manager;

import com.huawei.android.app.HwMultiWindowEx;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.utils.HwBuildEx;
import java.util.ArrayList;
import java.util.List;

public class MultiWindowAdapter {
    private static final String TAG = "MultiWindowAdapter";
    private static MultiWindowAdapter instance;
    private List<HwMultiWindowEx.StateChangeListener> data = new ArrayList<HwMultiWindowEx.StateChangeListener>();

    public static synchronized MultiWindowAdapter getInstance() {
        if (instance == null) {
            instance = new MultiWindowAdapter();
        }
        return instance;
    }

    public boolean isInMultiWindowMode() {
        if (!this.isSupportListenMultiWindowMode()) {
            BuoyLog.w(TAG, "get isInMultiWindowMode failed, not support multi window mode");
            return false;
        }
        return HwMultiWindowEx.isInMultiWindowMode();
    }

    public void registerModeChangeListener(final MultiWindowCallBack callback) {
        if (!this.isSupportListenMultiWindowMode()) {
            BuoyLog.w(TAG, "register failed, not support multi window mode");
            return;
        }
        HwMultiWindowEx.StateChangeListener listener = new HwMultiWindowEx.StateChangeListener(){

            public void onModeChanged(boolean b2) {
                if (b2) {
                    callback.startMultiWindow();
                } else {
                    callback.endMultiWindow();
                }
            }

            public void onZoneChanged() {
            }

            public void onSizeChanged() {
            }
        };
        HwMultiWindowEx.setStateChangeListener((HwMultiWindowEx.StateChangeListener)listener);
        this.data.add(listener);
    }

    public void unRegisterModeChangeListener() {
        if (!this.isSupportListenMultiWindowMode()) {
            BuoyLog.w(TAG, "unRegister failed, not support multi window mode");
            return;
        }
        for (HwMultiWindowEx.StateChangeListener listener : this.data) {
            HwMultiWindowEx.unregisterStateChangeListener((HwMultiWindowEx.StateChangeListener)listener);
        }
    }

    public boolean isSupportListenMultiWindowMode() {
        if (HwBuildEx.VERSION.EMUI_SDK_INT < 14) {
            BuoyLog.i(TAG, "emui version do not support hwsdk");
            return false;
        }
        return true;
    }

    static interface MultiWindowCallBack {
        public void startMultiWindow();

        public void endMultiWindow();
    }
}

