/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.remote;

import android.content.Context;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.remote.BuoyServiceApiClient;
import com.huawei.appmarket.component.buoycircle.impl.remote.RemoteBuoyApiInitTask;
import com.huawei.appmarket.component.buoycircle.impl.remote.RemoteBuoyApiRequestTask;
import com.huawei.appmarket.component.buoycircle.impl.remote.RunTask;
import com.huawei.appmarket.component.buoycircle.impl.remote.SequentialTaskManager;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import com.huawei.gamebox.plugin.gameservice.service.RequestInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteApiManager {
    private static final String TAG = "RemoteApiManager";
    private static RemoteApiManager instance = new RemoteApiManager();
    public static final String GAMESERVICE_SDK_VERSION_CODE = "70301300";
    public static final String GAMESERVICE_SDK_VERSION_NAME = "7.3.1.300";
    private RunTask removeSmallBuoyTask;
    private RunTask onServiceDisconnectTask;

    public void setRemoveSmallBuoyTask(RunTask removeSmallBuoyTask) {
        this.removeSmallBuoyTask = removeSmallBuoyTask;
    }

    public void setOnServiceDisconnectTask(RunTask onServiceDisconnectTask) {
        this.onServiceDisconnectTask = onServiceDisconnectTask;
    }

    public RunTask getRemoveSmallBuoyTask() {
        return this.removeSmallBuoyTask;
    }

    public RunTask getOnServiceDisconnectTask() {
        return this.onServiceDisconnectTask;
    }

    public static RemoteApiManager getInstance() {
        return instance;
    }

    public void showBuoyDialog(Context context, SequentialTaskManager.RunTaskResultHandler handler, int screentOrient, String appid, String cpid, String packageName) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        RequestInfo request = this.getRequestInfo("showBuoyDialog", appid, cpid, packageName, pmHelper.getPackageVersionCode(packageName));
        JSONObject param = new JSONObject();
        try {
            param.put("screentOrient", screentOrient);
        }
        catch (JSONException e2) {
            BuoyLog.e(TAG, "showBuoyDialog\uff0cput param meet exception");
        }
        request.setParams(param.toString());
        this.callBuoy(context, request, handler, true);
    }

    public void finishBuoyDialog(Context context, SequentialTaskManager.RunTaskResultHandler handler, String appid, String cpid, String packageName) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        RequestInfo request = this.getRequestInfo("finishBuoyDialog", appid, cpid, packageName, pmHelper.getPackageVersionCode(packageName));
        this.callBuoy(context, request, handler, true);
    }

    public void switchGameSubAcct(BuoyServiceApiClient.GameServiceApiHandler handler) {
        BuoyServiceApiClient.getInstance().registerHandler("switchGameSubAcct", handler);
    }

    public void getBuoyRedInfo(Context context, SequentialTaskManager.RunTaskResultHandler handler, String appid, String cpid, String packageName) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        RequestInfo request = this.getRequestInfo("getBuoyRedInfo", appid, cpid, packageName, pmHelper.getPackageVersionCode(packageName));
        this.callBuoy(context, request, handler, false);
    }

    public void getBuoyNewRedNotice(Context context, SequentialTaskManager.RunTaskResultHandler handler, String appid, String cpid, String packageName) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        RequestInfo request = this.getRequestInfo("getBuoyNewRedNotice", appid, cpid, packageName, pmHelper.getPackageVersionCode(packageName));
        this.callBuoy(context, request, handler, false);
    }

    public void getBuoyEntryInfo(Context context, SequentialTaskManager.RunTaskResultHandler handler, String appid, String cpid, String packageName) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        RequestInfo request = this.getRequestInfo("getGameBuoyEntryInfo", appid, cpid, packageName, pmHelper.getPackageVersionCode(packageName));
        this.callBuoy(context, request, handler, false);
    }

    private void callBuoy(Context context, RequestInfo request, SequentialTaskManager.RunTaskResultHandler handler, boolean needRetryAidl) {
        SequentialTaskManager taskManager = new SequentialTaskManager();
        RemoteBuoyApiInitTask initTask = new RemoteBuoyApiInitTask(context, needRetryAidl);
        RemoteBuoyApiRequestTask requestTask = new RemoteBuoyApiRequestTask(request);
        taskManager.addTask(initTask);
        taskManager.addTask(requestTask);
        taskManager.run(handler);
    }

    private RequestInfo getRequestInfo(String method, String appid, String cpid, String packageName, int versionCode) {
        RequestInfo request = new RequestInfo();
        request.setAppId(appid);
        request.setCpId(cpid);
        request.setSdkVersionName(GAMESERVICE_SDK_VERSION_NAME);
        request.setSdkVersionCode(GAMESERVICE_SDK_VERSION_CODE);
        request.setMethod(method);
        request.setPackageName(packageName);
        request.setVersionCode(String.valueOf(versionCode));
        return request;
    }

    public static interface Method {
        public static final String SWITCH_GAME_SUBACCT = "switchGameSubAcct";
        public static final String GET_BUOY_RED_INFO = "getBuoyRedInfo";
        public static final String GET_BUOY_NEW_RED_NOTICE = "getBuoyNewRedNotice";
        public static final String SHOW_BUOY_DIALOG = "showBuoyDialog";
        public static final String FINISH_BUOY_DIALOG = "finishBuoyDialog";
        public static final String GET_BUOY_ENTRY_INFO = "getGameBuoyEntryInfo";
    }
}

