/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.download;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.IOtaUpdate;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.IUpdateCallback;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.UpdateInfo;
import com.huawei.appmarket.component.buoycircle.impl.utils.Checker;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class ThreadWrapper
implements IOtaUpdate {
    private final IOtaUpdate mOtaUpdate;
    private static final Executor mWorkThread = Executors.newSingleThreadExecutor();

    public ThreadWrapper(IOtaUpdate update) {
        Checker.checkNonNull(update, "update must not be null.");
        this.mOtaUpdate = update;
    }

    @Override
    public Context getContext() {
        return this.mOtaUpdate.getContext();
    }

    @Override
    public void cancel() {
        this.mOtaUpdate.cancel();
    }

    @Override
    public void downloadPackage(final IUpdateCallback callback, final UpdateInfo updateInfo) {
        mWorkThread.execute(new Runnable(){

            @Override
            public void run() {
                ThreadWrapper.this.mOtaUpdate.downloadPackage(ThreadWrapper.wrapUpdateCallback(callback), updateInfo);
            }
        });
    }

    private static IUpdateCallback wrapUpdateCallback(final IUpdateCallback callback) {
        return new IUpdateCallback(){

            @Override
            public void onCheckUpdate(final int status, final UpdateInfo updateInfo) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCheckUpdate(status, updateInfo);
                    }
                });
            }

            @Override
            public void onDownloadPackage(final int status, final int received, final int total, final File localFile) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onDownloadPackage(status, received, total, localFile);
                    }
                });
            }
        };
    }
}

