/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.http;

import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

final class TLSSocketFactory
extends SSLSocketFactory {
    private static final String TAG = "TLSSocketFactory";
    private static final Object LOCK_INST = new Object();
    private final SSLContext mSSLContext = SSLContext.getInstance("TLSv1.2");
    private static SocketFactory mSocketFactory;

    private TLSSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        this.mSSLContext.init(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketFactory getInstance() {
        Object object = LOCK_INST;
        synchronized (object) {
            try {
                if (mSocketFactory == null) {
                    mSocketFactory = new TLSSocketFactory();
                }
                return mSocketFactory;
            }
            catch (KeyManagementException | NoSuchAlgorithmException e2) {
                BuoyLog.e(TAG, "Failed to new TLSSocketFactory instance");
                return SSLSocketFactory.getDefault();
            }
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return new String[0];
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return new String[0];
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.mSSLContext.getSocketFactory().createSocket(s2, host, port, autoClose);
        this.setSocketOptions(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket s2 = this.mSSLContext.getSocketFactory().createSocket(host, port);
        this.setSocketOptions(s2);
        return s2;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket s2 = this.mSSLContext.getSocketFactory().createSocket(host, port, localHost, localPort);
        this.setSocketOptions(s2);
        return s2;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket s2 = this.mSSLContext.getSocketFactory().createSocket(host, port);
        this.setSocketOptions(s2);
        return s2;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket s2 = this.mSSLContext.getSocketFactory().createSocket(address, port, localAddress, localPort);
        this.setSocketOptions(s2);
        return s2;
    }

    private void setSocketOptions(Socket s2) {
        if (s2 instanceof SSLSocket) {
            this.setEnabledProtocols((SSLSocket)s2);
            TLSSocketFactory.setEnableSafeCipherSuites((SSLSocket)s2);
        }
    }

    private void setEnabledProtocols(SSLSocket s2) {
        s2.setEnabledProtocols(new String[]{"TLSv1.2"});
    }

    public static void setEnableSafeCipherSuites(SSLSocket s2) {
        String[] cipherSuites = s2.getEnabledCipherSuites();
        if (cipherSuites == null || cipherSuites.length == 0) {
            return;
        }
        ArrayList<String> enabledCipherSuiteList = new ArrayList<String>();
        for (String string : cipherSuites) {
            if (string.contains("RC2") || string.contains("RC4") || string.contains("DES") || string.contains("MD2") || string.contains("MD4") || string.contains("MD5") || string.contains("ANON") || string.contains("NULL") || string.contains("SKIPJACK") || string.contains("SHA1") || string.contains("TEA") || string.contains("SHA0") || string.contains("RIPEMD") || string.contains("TLS_EMPTY_RENEGOTIATION_INFO_SCSV")) continue;
            enabledCipherSuiteList.add(string);
        }
        String[] enabledCipherSuites = enabledCipherSuiteList.toArray(new String[enabledCipherSuiteList.size()]);
        s2.setEnabledCipherSuites(enabledCipherSuites);
    }
}

