/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.AbsUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.AbstractDialog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.InstallConfirmDialog;

public class HiAppUpdateDelegate
extends AbsUpdateDelegate {
    private static final String TAG = "HiAppUpdateDelegate";

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        super.onBridgeActivityCreate(activity);
        if (this.bean == null) {
            return;
        }
        this.updateType = 5;
        if (this.bean.isNeedConfirm() && !TextUtils.isEmpty((CharSequence)this.mClientAppName)) {
            this.showDialog(InstallConfirmDialog.class);
        } else if (!this.gotoHiappForUpdate()) {
            if (!this.startNextWizard(false)) {
                this.finishBridgeActivity(8, this.updateType);
            } else {
                this.biReportEvent(8, this.updateType);
            }
        }
    }

    @Override
    public void onBridgeActivityDestroy() {
        super.onBridgeActivityDestroy();
    }

    @Override
    public int getRequestCode() {
        return 2005;
    }

    @Override
    public boolean onBridgeActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            return this.mBridgeActivityDelegate.onBridgeActivityResult(requestCode, resultCode, data);
        }
        if (this.updateType == 5 && requestCode == this.getRequestCode()) {
            if (this.isUpdated(this.mPackageName, this.mClientVersionCode)) {
                this.finishBridgeActivity(0, this.updateType);
            } else {
                this.finishBridgeActivity(8, this.updateType);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBridgeConfigurationChanged() {
        super.onBridgeConfigurationChanged();
    }

    @Override
    public void onCancel(AbstractDialog dialog) {
        BuoyLog.i(TAG, "Enter onCancel.");
        if (dialog instanceof InstallConfirmDialog) {
            this.userCancelUpdate();
        }
    }

    @Override
    public void onDoWork(AbstractDialog dialog) {
        BuoyLog.i(TAG, "Enter onDoWork.");
        if (dialog instanceof InstallConfirmDialog) {
            dialog.dismiss();
            if (!this.gotoHiappForUpdate()) {
                if (!this.startNextWizard(false)) {
                    this.finishBridgeActivity(8, this.updateType);
                } else {
                    this.biReportEvent(8, this.updateType);
                }
            }
        }
    }

    private boolean gotoHiappForUpdate() {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mPackageName)) {
            return false;
        }
        try {
            Intent intent = new Intent();
            intent.setAction("com.huawei.appmarket.intent.action.AppDetail");
            intent.putExtra("APP_PACKAGENAME", this.mPackageName);
            intent.setPackage("com.huawei.appmarket");
            activity.startActivityForResult(intent, this.getRequestCode());
        }
        catch (ActivityNotFoundException anfe) {
            BuoyLog.e(TAG, "can not open hiapp");
            return false;
        }
        return true;
    }

    @Override
    void showDialog(Class<? extends AbstractDialog> dialogClass) {
        this.dismissDialog();
        try {
            AbstractDialog dialog = dialogClass.newInstance();
            if (!TextUtils.isEmpty((CharSequence)this.mClientAppName) && dialog instanceof InstallConfirmDialog) {
                ((InstallConfirmDialog)dialog).intAppName(this.mClientAppName);
            }
            dialog.show(this);
            this.mLatestDialog = dialog;
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException e2) {
            BuoyLog.e(TAG, "In showDialog, Failed to show the dialog");
        }
    }

    @Override
    void userCancelUpdate() {
        this.finishBridgeActivity(13, this.updateType);
    }

    @Override
    public void onKeyUp(int keyCode, KeyEvent event) {
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onKeyUp(keyCode, event);
            return;
        }
        if (4 == keyCode) {
            BuoyLog.i(TAG, "In onKeyUp, Call finish.");
            Activity activity = this.getActivity();
            if (activity != null && !activity.isFinishing()) {
                activity.setResult(0, null);
                activity.finish();
            }
        }
    }
}

