/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.download.ThreadWrapper;
import com.huawei.appmarket.component.buoycircle.impl.update.download.UpdateDownload;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.IOtaUpdate;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.IUpdateCallback;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.UpdateInfo;
import com.huawei.appmarket.component.buoycircle.impl.update.download.api.UpdateStatus;
import com.huawei.appmarket.component.buoycircle.impl.update.provider.UpdateProvider;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.AbsUpdateDelegate;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.AbstractDialog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.CheckUpdateDialog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.ConfirmUpdateDialog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.DownloadProgressDialog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.InstallConfirmDialog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.PromptDialogs;
import com.huawei.appmarket.component.buoycircle.impl.utils.PackageManagerHelper;
import com.huawei.updatesdk.UpdateSdkAPI;
import com.huawei.updatesdk.service.appmgr.bean.ApkUpgradeInfo;
import com.huawei.updatesdk.service.otaupdate.CheckUpdateCallBack;
import java.io.File;

public class OtaUpdateDelegate
extends AbsUpdateDelegate
implements IUpdateCallback {
    private static final String TAG = "BuoyUpdateDelegate";
    private IOtaUpdate mUpdate;
    private UpdateInfo mUpdateInfo;
    private int mCurProgress = 0;

    @Override
    public void onBridgeActivityCreate(Activity activity) {
        super.onBridgeActivityCreate(activity);
        if (this.bean == null) {
            return;
        }
        this.updateType = 6;
        if (this.bean.isNeedConfirm() && !TextUtils.isEmpty((CharSequence)this.mClientAppName)) {
            this.showDialog(InstallConfirmDialog.class);
        } else {
            this.showDialog(CheckUpdateDialog.class);
            this.checkUpdate(this);
        }
    }

    @Override
    public void onBridgeActivityDestroy() {
        this.cancelUpdate();
        super.onBridgeActivityDestroy();
    }

    @Override
    public int getRequestCode() {
        return 2006;
    }

    @Override
    public boolean onBridgeActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            return this.mBridgeActivityDelegate.onBridgeActivityResult(requestCode, resultCode, data);
        }
        if (this.updateType == 6 && requestCode == this.getRequestCode()) {
            if (this.isUpdated(this.mPackageName, this.mClientVersionCode)) {
                this.finishBridgeActivity(0, this.updateType);
            } else {
                this.downloadFaild();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onCheckUpdate(int status, UpdateInfo updateInfo) {
        BuoyLog.i(TAG, "Enter onCheckUpdate, status: " + UpdateStatus.statusToString(status));
        switch (status) {
            case 1000: {
                this.mUpdateInfo = updateInfo;
                this.showDialog(DownloadProgressDialog.class);
                this.downloadPackage();
                break;
            }
            case 1201: 
            case 1202: 
            case 1203: {
                this.showDialog(PromptDialogs.CheckFailurePrompt.class);
                break;
            }
            default: {
                this.showDialog(PromptDialogs.CheckFailurePrompt.class);
            }
        }
    }

    @Override
    public void onDownloadPackage(int status, int received, int total, File localFile) {
        BuoyLog.d(TAG, "Enter onDownloadPackage, status: " + UpdateStatus.statusToString(status) + ", reveived: " + received + ", total: " + total);
        switch (status) {
            case 2000: {
                this.dismissDialog();
                if (localFile == null) {
                    this.downloadFaild();
                    break;
                }
                this.startInstaller(localFile);
                break;
            }
            case 2101: {
                break;
            }
            case 2100: {
                if (this.mLatestDialog == null || !(this.mLatestDialog instanceof DownloadProgressDialog)) break;
                int progress = 0;
                if (received >= 0 && total > 0) {
                    progress = (int)((long)received * 100L / (long)total);
                }
                this.mCurProgress = progress;
                ((DownloadProgressDialog)this.mLatestDialog).setDownloading(progress);
                break;
            }
            case 2201: {
                this.showDialog(PromptDialogs.DownloadFailurePrompt.class);
                break;
            }
            case 2203: 
            case 2204: {
                this.showDialog(PromptDialogs.DownloadNoSpacePrompt.class);
                break;
            }
            case 2202: {
                this.showDialog(ConfirmUpdateDialog.RetryConfirm.class);
                break;
            }
        }
    }

    private void startInstaller(File localFile) {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        Uri uri = OtaUpdateDelegate.contentUriFromFile((Context)activity, localFile);
        if (uri == null) {
            BuoyLog.e(TAG, "In startInstaller, Failed to creates a Uri from a file.");
            this.downloadFaild();
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        intent.setFlags(3);
        try {
            activity.startActivityForResult(intent, this.getRequestCode());
        }
        catch (ActivityNotFoundException e2) {
            BuoyLog.e(TAG, "In startInstaller, Failed to start package installer");
            this.downloadFaild();
        }
    }

    private static Uri contentUriFromFile(Context context, File file) {
        PackageManagerHelper pmHelper = new PackageManagerHelper(context);
        String packageName = context.getPackageName();
        String authority = packageName + ".hms.update.provider";
        boolean usingContentURI = false;
        if (Build.VERSION.SDK_INT > 23) {
            if (context.getApplicationInfo().targetSdkVersion > 23) {
                usingContentURI = true;
            } else if (pmHelper.hasProvider(packageName, authority)) {
                usingContentURI = true;
            }
        }
        if (usingContentURI) {
            return UpdateProvider.getUriForFile(context, authority, file);
        }
        return Uri.fromFile((File)file);
    }

    @Override
    public void onCancel(AbstractDialog dialog) {
        BuoyLog.i(TAG, "Enter onCancel.");
        if (dialog instanceof InstallConfirmDialog) {
            this.userCancelUpdate();
        } else if (dialog instanceof CheckUpdateDialog) {
            this.cancelUpdate();
            this.userCancelUpdate();
        } else if (dialog instanceof DownloadProgressDialog) {
            this.cancelUpdate();
            this.showDialog(ConfirmUpdateDialog.StopConfirm.class);
        } else if (dialog instanceof ConfirmUpdateDialog.StopConfirm) {
            this.showDialog(DownloadProgressDialog.class);
            this.downloadPackage();
        } else if (dialog instanceof ConfirmUpdateDialog.RetryConfirm) {
            this.userCancelUpdate();
        } else {
            this.downloadFaild();
        }
    }

    @Override
    public void onDoWork(AbstractDialog dialog) {
        BuoyLog.i(TAG, "Enter onDoWork.");
        if (dialog instanceof InstallConfirmDialog) {
            dialog.dismiss();
            this.showDialog(CheckUpdateDialog.class);
            this.checkUpdate(this);
        } else if (dialog instanceof ConfirmUpdateDialog.StopConfirm) {
            dialog.dismiss();
            this.userCancelUpdate();
        } else if (dialog instanceof ConfirmUpdateDialog.RetryConfirm) {
            this.showDialog(DownloadProgressDialog.class);
            this.downloadPackage();
        } else if (dialog instanceof PromptDialogs.CheckFailurePrompt) {
            this.downloadFaild();
        } else if (dialog instanceof PromptDialogs.DownloadFailurePrompt) {
            this.downloadFaild();
        } else if (dialog instanceof PromptDialogs.DownloadNoSpacePrompt) {
            this.downloadFaild();
        }
    }

    private void downloadFaild() {
        if (!this.startNextWizard(false)) {
            this.finishBridgeActivity(8, this.updateType);
        } else {
            this.biReportEvent(8, this.updateType);
        }
    }

    @Override
    void showDialog(Class<? extends AbstractDialog> dialogClass) {
        this.dismissDialog();
        try {
            AbstractDialog dialog = dialogClass.newInstance();
            if (!TextUtils.isEmpty((CharSequence)this.mClientAppName) && dialog instanceof InstallConfirmDialog) {
                ((InstallConfirmDialog)dialog).intAppName(this.mClientAppName);
            }
            if (this.mCurProgress > 0 && dialog instanceof DownloadProgressDialog) {
                ((DownloadProgressDialog)dialog).intProgress(this.mCurProgress);
            }
            dialog.show(this);
            this.mLatestDialog = dialog;
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException e2) {
            BuoyLog.e(TAG, "In showDialog, Failed to show the dialog.");
        }
    }

    @Override
    void userCancelUpdate() {
        this.finishBridgeActivity(13, this.updateType);
    }

    private void checkUpdate(final IUpdateCallback callback) {
        if (callback == null) {
            return;
        }
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            OtaUpdateDelegate.checkCallback(callback, 1201, null);
            return;
        }
        UpdateSdkAPI.checkTargetAppUpdate((Context)activity, this.bean.getClientPackageName(), new CheckUpdateCallBack(){

            @Override
            public void onUpdateInfo(Intent intent) {
                if (intent != null) {
                    int status;
                    try {
                        status = intent.getIntExtra("status", -99);
                    }
                    catch (Exception e2) {
                        BuoyLog.e(OtaUpdateDelegate.TAG, "intent has some error");
                        OtaUpdateDelegate.checkCallback(callback, 1201, null);
                        return;
                    }
                    if (status == 7) {
                        ApkUpgradeInfo info = (ApkUpgradeInfo)intent.getSerializableExtra("updatesdk_update_info");
                        if (info != null) {
                            String packageName = info.getPackage_();
                            int versionCode = info.getVersionCode_();
                            String fullDownloadUrl = info.getDownurl_();
                            int size = info.getSize_();
                            String sha256 = info.getSha256_();
                            BuoyLog.i("UpdateTest", "versionCode:" + versionCode);
                            BuoyLog.i("UpdateTest", "bean.getClientVersionCode():" + OtaUpdateDelegate.this.bean.getClientVersionCode());
                            if (TextUtils.isEmpty((CharSequence)packageName) || !packageName.equals(OtaUpdateDelegate.this.bean.getClientPackageName())) {
                                OtaUpdateDelegate.checkCallback(callback, 1201, null);
                                return;
                            }
                            if (versionCode < OtaUpdateDelegate.this.bean.getClientVersionCode()) {
                                OtaUpdateDelegate.checkCallback(callback, 1203, null);
                                return;
                            }
                            if (TextUtils.isEmpty((CharSequence)fullDownloadUrl) || TextUtils.isEmpty((CharSequence)sha256)) {
                                OtaUpdateDelegate.checkCallback(callback, 1201, null);
                                return;
                            }
                            UpdateInfo updateInfo = new UpdateInfo(packageName, versionCode, fullDownloadUrl, size, sha256);
                            OtaUpdateDelegate.checkCallback(callback, 1000, updateInfo);
                        }
                    } else if (status == 3) {
                        OtaUpdateDelegate.checkCallback(callback, 1202, null);
                    } else {
                        OtaUpdateDelegate.checkCallback(callback, 1201, null);
                    }
                }
            }

            @Override
            public void onMarketInstallInfo(Intent intent) {
            }

            @Override
            public void onMarketStoreError(int i2) {
            }

            @Override
            public void onUpdateStoreError(int i2) {
            }
        });
    }

    private static void checkCallback(final IUpdateCallback callback, final int code, final UpdateInfo updateInfo) {
        if (callback != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    callback.onCheckUpdate(code, updateInfo);
                }
            });
        }
    }

    private void downloadPackage() {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            this.showDialog(PromptDialogs.DownloadFailurePrompt.class);
            return;
        }
        this.cancelUpdate();
        this.mUpdate = new ThreadWrapper(new UpdateDownload((Context)activity));
        this.mUpdate.downloadPackage(this, this.mUpdateInfo);
    }

    private void cancelUpdate() {
        if (this.mUpdate != null) {
            this.mUpdate.cancel();
            this.mUpdate = null;
        }
    }

    @Override
    public void onKeyUp(int keyCode, KeyEvent event) {
        if (this.needTransfer && this.mBridgeActivityDelegate != null) {
            this.mBridgeActivityDelegate.onKeyUp(keyCode, event);
            return;
        }
        if (4 == keyCode) {
            BuoyLog.i(TAG, "In onKeyUp, Call finish.");
            Activity activity = this.getActivity();
            if (activity != null && !activity.isFinishing()) {
                activity.setResult(0, null);
                activity.finish();
            }
        }
    }
}

