/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.delegate.AbsUpdateDelegate;

public abstract class AbstractDialog {
    private static final String TAG = "AbstractDialog";
    private AlertDialog mDialog;
    private AbsUpdateDelegate mUpdateWizard;

    protected abstract AlertDialog onCreateDialog();

    public void show(AbsUpdateDelegate updateWizard) {
        this.mUpdateWizard = updateWizard;
        if (this.getActivity() == null || this.getActivity().isFinishing()) {
            BuoyLog.e(TAG, "In show, The activity is null or finishing.");
            return;
        }
        this.mDialog = this.onCreateDialog();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                AbstractDialog.this.fireCancel();
            }
        });
        this.mDialog.show();
    }

    public void cancel() {
        if (this.mDialog != null) {
            this.mDialog.cancel();
        }
    }

    public void dismiss() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    protected void fireCancel() {
        if (this.mUpdateWizard != null) {
            this.mUpdateWizard.onCancel(this);
        }
    }

    protected void fireDoWork() {
        if (this.mUpdateWizard != null) {
            this.mUpdateWizard.onDoWork(this);
        }
    }

    protected Activity getActivity() {
        if (this.mUpdateWizard != null) {
            return this.mUpdateWizard.getActivity();
        }
        return null;
    }

    protected int getDialogThemeId() {
        if (AbstractDialog.getThemeEmui((Context)this.getActivity()) != 0 && Build.VERSION.SDK_INT >= 16) {
            return 0;
        }
        return 3;
    }

    private static int getThemeEmui(Context context) {
        if (context == null) {
            return 0;
        }
        return context.getResources().getIdentifier("androidhwext:style/Theme.Emui", null, null);
    }
}

