/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import com.huawei.appmarket.component.buoycircle.impl.update.ui.dialog.AbstractDialog;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;
import java.text.NumberFormat;

public class DownloadProgressDialog
extends AbstractDialog {
    private static final String TAG = "DownloadProgressDialog";
    private ProgressBar mProgressBar;
    private TextView mProgressInfo;
    private int mProgress = 0;
    private DialogInterface.OnKeyListener keylistener = new CustomOnKeyListener();

    @Override
    public AlertDialog onCreateDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity(), this.getDialogThemeId());
        View dialogView = View.inflate((Context)this.getActivity(), (int)ResourceLoaderUtil.getLayoutId("c_buoycircle_download_progress"), null);
        builder.setView(dialogView);
        builder.setCancelable(false);
        builder.setOnKeyListener(this.keylistener);
        this.mProgressBar = (ProgressBar)dialogView.findViewById(ResourceLoaderUtil.getIdId("download_info_progress"));
        this.mProgressInfo = (TextView)dialogView.findViewById(ResourceLoaderUtil.getIdId("progress_text"));
        this.setDownloading(this.mProgress);
        return builder.create();
    }

    public void intProgress(int progress) {
        this.mProgress = progress;
    }

    public void setDownloading(int progress) {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            BuoyLog.w(TAG, "In setDownloading, The activity is null or finishing.");
            return;
        }
        if (this.mProgressInfo == null || this.mProgressBar == null) {
            return;
        }
        this.mProgressBar.setProgress(progress);
        NumberFormat pnf = NumberFormat.getPercentInstance();
        String percent = pnf.format((float)progress / 100.0f);
        this.mProgressInfo.setText((CharSequence)percent);
    }

    private static class CustomOnKeyListener
    implements DialogInterface.OnKeyListener {
        private CustomOnKeyListener() {
        }

        public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
            return keyCode == 4 && event.getRepeatCount() == 0;
        }
    }
}

