/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public final class NetworkUtil {
    public static int getNetworkType(Context context) {
        return NetworkUtil.getPsType(NetworkUtil.getActiveNetworkInfo(context));
    }

    private static NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (null != mConnMgr) {
            networkInfo = mConnMgr.getActiveNetworkInfo();
        }
        return networkInfo;
    }

    private static int getPsType(NetworkInfo netInfo) {
        int psType = 0;
        if (netInfo != null && netInfo.isConnected()) {
            if (netInfo.getType() == 1) {
                psType = 1;
            } else if (0 == netInfo.getType()) {
                int subtype = netInfo.getSubtype();
                switch (subtype) {
                    case 1: 
                    case 2: 
                    case 4: {
                        psType = 2;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: {
                        psType = 3;
                        break;
                    }
                    case 13: 
                    case 14: {
                        psType = 4;
                        break;
                    }
                    default: {
                        psType = 6;
                    }
                }
            }
        }
        return psType;
    }

    public static boolean hasActiveNetwork(Context context) {
        NetworkInfo netInfo;
        ConnectivityManager manager;
        return null != context && null != (manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity")) && (netInfo = manager.getActiveNetworkInfo()) != null && netInfo.isConnected();
    }

    public static final class NetType {
        public static final int WAP = -3;
        public static final int NET = -2;
        public static final int TYPE_NEED_INIT = -1;
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WIFI = 1;
        public static final int TYPE_2G = 2;
        public static final int TYPE_3G = 3;
        public static final int TYPE_4G = 4;
        public static final int TYPE_5G = 5;
        public static final int TYPE_OTHER = 6;
    }
}

