/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.text.TextUtils;
import com.huawei.appmarket.component.buoycircle.impl.log.BuoyLog;
import java.util.List;

public class PackageManagerHelper {
    private static final String TAG = "PackageManagerHelper";
    private final PackageManager mPM;
    public static final int ERROR_PID = -1;

    public PackageManagerHelper(Context context) {
        this.mPM = context.getPackageManager();
    }

    public PackageStates getPackageStates(String packageName) {
        try {
            ApplicationInfo appInfo = this.mPM.getApplicationInfo(packageName, 0);
            if (appInfo.enabled) {
                return PackageStates.ENABLED;
            }
            return PackageStates.DISABLED;
        }
        catch (PackageManager.NameNotFoundException e2) {
            return PackageStates.NOT_INSTALLED;
        }
    }

    public int getPackageVersionCode(String packageName) {
        try {
            PackageInfo packageInfo = this.mPM.getPackageInfo(packageName, 16);
            if (packageInfo != null) {
                return packageInfo.versionCode;
            }
            return 0;
        }
        catch (PackageManager.NameNotFoundException e2) {
            return 0;
        }
    }

    public boolean hasProvider(String packageName, String authority) {
        try {
            PackageInfo packageInfo = this.mPM.getPackageInfo(packageName, 8);
            if (packageInfo != null && packageInfo.providers != null) {
                for (ProviderInfo providerInfo : packageInfo.providers) {
                    if (!authority.equals(providerInfo.authority)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (PackageManager.NameNotFoundException e2) {
            return false;
        }
    }

    public static boolean isBackground(Context context, String packageName) {
        if (context == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            BuoyLog.i(TAG, "packageName is empty, get packageName from context");
            packageName = context.getPackageName();
        }
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return false;
            }
            List appProcesses = activityManager.getRunningAppProcesses();
            if (appProcesses == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (!appProcess.processName.equals(packageName) || appProcess.importance <= 200) continue;
                return true;
            }
        }
        catch (Exception e2) {
            BuoyLog.e(TAG, "check the app isBackground meet exception");
        }
        return false;
    }

    public static int getPid(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            BuoyLog.w(TAG, "packageName = " + packageName);
            return -1;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            BuoyLog.w(TAG, "activityManager = null");
            return -1;
        }
        List runningAppProcesses = activityManager.getRunningAppProcesses();
        if (runningAppProcesses == null || runningAppProcesses.size() == 0) {
            return -1;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcess : runningAppProcesses) {
            String processName = runningAppProcess.processName;
            if (!packageName.equals(processName)) continue;
            return runningAppProcess.pid;
        }
        return -1;
    }

    public static enum PackageStates {
        ENABLED,
        DISABLED,
        NOT_INSTALLED;

    }
}

