/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.appmarket.component.buoycircle.impl.view;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import com.huawei.appmarket.component.buoycircle.api.AppInfo;
import com.huawei.appmarket.component.buoycircle.impl.bi.BuoyAnalyticHelper;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyAutoHideSensorManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.BuoyHideCacheManager;
import com.huawei.appmarket.component.buoycircle.impl.manager.FloatWindowManager;
import com.huawei.appmarket.component.buoycircle.impl.storage.BuoyStorage;
import com.huawei.appmarket.component.buoycircle.impl.utils.ActivityUtil;
import com.huawei.appmarket.component.buoycircle.impl.utils.ResourceLoaderUtil;

public class BuoyHideGuideDialog {
    public static AlertDialog getGuideDialog(final Context context, final AppInfo appInfo, boolean supportSensor) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context, BuoyHideGuideDialog.getDialogThemeId(context));
        builder.setTitle(ResourceLoaderUtil.getStringId("c_buoycircle_hide_guide_title"));
        final View view = View.inflate((Context)context, (int)ResourceLoaderUtil.getLayoutId("c_buoycircle_hide_guide_dialog"), null);
        if (supportSensor) {
            ((TextView)view.findViewById(ResourceLoaderUtil.getIdId("game_id_buoy_hide_guide_text"))).setText((CharSequence)ResourceLoaderUtil.getString("c_buoycircle_hide_guide_content_sensor"));
        } else {
            TextView textView = (TextView)view.findViewById(ResourceLoaderUtil.getIdId("game_id_buoy_hide_guide_text"));
            textView.setText((CharSequence)ResourceLoaderUtil.getString("c_buoycircle_hide_guide_content_nosensor"));
            textView.setPadding(0, 0, 0, ActivityUtil.dp2Px(context, 16.0f));
            view.findViewById(ResourceLoaderUtil.getIdId("game_id_buoy_hide_guide_gif")).setVisibility(8);
        }
        builder.setView(view);
        builder.setPositiveButton(ResourceLoaderUtil.getStringId("c_buoycircle_hide_guide_btn_confirm"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                BuoyHideGuideDialog.handleConfirmHide(view, context, appInfo);
            }
        });
        builder.setNegativeButton(ResourceLoaderUtil.getStringId("c_buoycircle_hide_guide_btn_cancel"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                BuoyHideGuideDialog.handleCancelHide(context);
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                BuoyHideGuideDialog.handleCancelHide(context);
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(true);
        return dialog;
    }

    private static void handleConfirmHide(View view, Context context, AppInfo appInfo) {
        CheckBox checkBox = (CheckBox)view.findViewById(ResourceLoaderUtil.getIdId("game_id_buoy_hide_guide_remind"));
        if (checkBox.isChecked()) {
            BuoyStorage.getInstance().saveHideGuideRecord(context);
        }
        BuoyHideCacheManager.getInstance().saveHideBuoyEvent(context, appInfo, 2);
        if (appInfo != null) {
            BuoyAnalyticHelper.getInstance().onReportHideSmallBuoy(context, appInfo);
        }
        if (context instanceof Activity && !"com.huawei.gamebox".equals(context.getPackageName())) {
            ((Activity)context).finish();
        }
    }

    private static void handleCancelHide(Context context) {
        FloatWindowManager.getInstance().refreshSmallWindow(true);
        BuoyAutoHideSensorManager.getInstance().unRegisterSensor();
        if (context instanceof Activity && !"com.huawei.gamebox".equals(context.getPackageName())) {
            ((Activity)context).finish();
        }
    }

    protected static int getDialogThemeId(Context context) {
        if (BuoyHideGuideDialog.getThemeEmui(context) != 0 && Build.VERSION.SDK_INT >= 16) {
            return 0;
        }
        return 16974394;
    }

    private static int getThemeEmui(Context context) {
        if (context == null) {
            return 0;
        }
        return context.getResources().getIdentifier("androidhwext:style/Theme.Emui", null, null);
    }
}

