/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hianalytics.process;

import com.huawei.hianalytics.e.b;
import com.huawei.hianalytics.e.c;
import com.huawei.hianalytics.util.f;

public class HiAnalyticsConfig {
    c cfgData;

    public HiAnalyticsConfig(HiAnalyticsConfig hiAnalyticsConfig) {
        this.cfgData = new c(hiAnalyticsConfig.cfgData);
    }

    private HiAnalyticsConfig(Builder builder) {
        this.cfgData = new c();
        this.setDeviceConfig(builder);
        this.setChannel(builder.channel);
        this.setCollectURL(builder.collectURL);
        this.setMccMncEnabled(builder.isMccMncEnabled);
        this.setSionEnable(builder.isSessionEnabled);
        this.setLimitSize(builder.portLimitSize);
        this.setCacheExpiryTime(builder.expiryTime);
        this.setUUIDEnabled(builder.isUUIDEnabled);
    }

    private void setDeviceConfig(Builder builder) {
        b b2 = this.cfgData.a();
        b2.a(builder.isImeiEnabled);
        b2.a(builder.imeiCustom);
        b2.d(builder.isAndroidIdEnabled);
        b2.c(builder.androidIdCustom);
        b2.b(builder.isSNEnabled);
        b2.d(builder.snCustom);
        b2.c(builder.isUDIDEnabled);
        b2.b(builder.udidCustom);
    }

    private void setCacheExpiryTime(int n2) {
        this.cfgData.a(n2);
    }

    public void setUUIDEnabled(boolean bl) {
        this.cfgData.c(bl);
    }

    private void setSionEnable(boolean bl) {
        this.cfgData.a(bl);
    }

    private void setLimitSize(int n2) {
        this.cfgData.b(n2);
    }

    private void setMccMncEnabled(boolean bl) {
        this.cfgData.b(bl);
    }

    private void setChannel(String string) {
        this.cfgData.a(string);
    }

    private void setCollectURL(String string) {
        this.cfgData.b(string);
    }

    public static final class Builder {
        private boolean isImeiEnabled;
        private boolean isSNEnabled;
        private boolean isUDIDEnabled;
        private boolean isAndroidIdEnabled;
        private String channel;
        private String collectURL;
        private String imeiCustom;
        private String udidCustom;
        private String androidIdCustom;
        private String snCustom;
        private int portLimitSize = 10;
        private int expiryTime = 7;
        private boolean isMccMncEnabled;
        private boolean isSessionEnabled;
        private boolean isUUIDEnabled = true;

        public Builder setEnableSession(boolean bl) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setEnableSession() is executed.");
            this.isSessionEnabled = bl;
            return this;
        }

        @Deprecated
        public Builder setEnableImei(boolean bl) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setEnableImei() is executed.");
            this.isImeiEnabled = bl;
            return this;
        }

        @Deprecated
        public Builder setEnableSN(boolean bl) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setEnableSN() is executed.");
            this.isSNEnabled = bl;
            return this;
        }

        @Deprecated
        public Builder setEnableUDID(boolean bl) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setEnableUDID() is executed.");
            this.isUDIDEnabled = bl;
            return this;
        }

        @Deprecated
        public Builder setEnableAndroidID(boolean bl) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setEnableAndroidID() is executed.");
            this.isAndroidIdEnabled = bl;
            return this;
        }

        public Builder setEnableMccMnc(boolean bl) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setEnableMccMnc() is executed.");
            this.isMccMncEnabled = bl;
            return this;
        }

        public Builder setChannel(String string) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setChannel() is executed.");
            if (!f.a("channel", string, 256)) {
                string = "";
            }
            this.channel = string;
            return this;
        }

        public Builder setAutoReportThreshold(int n2) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setAutoReportThreshold() is executed.");
            this.portLimitSize = f.a(n2, 500, 10);
            return this;
        }

        public Builder setCacheExpireTime(int n2) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setCacheExpireTime() is executed.");
            this.expiryTime = f.a(n2, 7, 2);
            return this;
        }

        public Builder setCollectURL(String string) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setCollectURL() is executed.");
            if (!f.a(string, "(https://)[a-zA-Z0-9-_]+[\\.a-zA-Z0-9_-]*(\\.hicloud\\.com)(:(\\d){2,5})?(\\\\|\\/)?")) {
                string = "";
            }
            if (string.endsWith("/") || string.endsWith("\\")) {
                string = string.substring(0, string.length() - 1);
            }
            this.collectURL = string;
            return this;
        }

        public Builder setImei(String string) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setImei() is executed.");
            if (!f.a("IMEI_CustomSet", string, 4096)) {
                string = "";
            }
            this.imeiCustom = string;
            return this;
        }

        public Builder setUdid(String string) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setUdid() is executed.");
            if (!f.a("Udid_CustomSet", string, 4096)) {
                string = "";
            }
            this.udidCustom = string;
            return this;
        }

        public Builder setSN(String string) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setSN() is executed.");
            if (!f.a("SN_CustomSet", string, 4096)) {
                string = "";
            }
            this.snCustom = string;
            return this;
        }

        public Builder setAndroidId(String string) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setAndroidId() is executed.");
            if (!f.a("AndroidId_CustomSet", string, 4096)) {
                string = "";
            }
            this.androidIdCustom = string;
            return this;
        }

        public Builder setEnableUUID(boolean bl) {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.setEnableUUID() is executed.");
            this.isUUIDEnabled = bl;
            return this;
        }

        public HiAnalyticsConfig build() {
            com.huawei.hianalytics.g.b.a("HianalyticsSDK", "HiAnalyticsConf.Builder.build() is executed.");
            return new HiAnalyticsConfig(this);
        }
    }
}

