/*
 * Decompiled with CFR 0.152.
 */
package com.coloros.mcssdk;

import android.content.Context;
import android.content.Intent;
import com.coloros.mcssdk.a.d;
import com.coloros.mcssdk.b;
import com.coloros.mcssdk.b.a;
import com.coloros.mcssdk.c;
import com.coloros.mcssdk.c.e;
import com.coloros.mcssdk.callback.PushCallback;
import com.coloros.mcssdk.mode.AppMessage;
import com.coloros.mcssdk.mode.CommandMessage;
import com.coloros.mcssdk.mode.SptDataMessage;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PushManager {
    private Context mContext;
    public static final String MCS_PACKAGE = "com.coloros.mcs";
    public static final String MCS_RECEIVE_SDK_ACTION = "com.coloros.mcssdk.action.RECEIVE_SDK_MESSAGE";
    public static final String TYPE = "type";
    private static final String VERSION = "1.0.1";
    public static final int MCS_SUPPORT_VERSION = 1012;
    public static final String EVENT_ID = "eventID";
    public static final String TASK_ID = "taskID";
    public static final String APP_PACKAGE = "appPackage";
    public static final String MESSAGE_TYPE = "messageType";
    public static final String MESSAGE_TYPE_APP = "push_message";
    public static final String MESSAGE_TYPE_NOTI = "notification";
    public static final String MESSAGE_TYPE_SPT_DATA = "spt_data";
    public static final String MESSAGE_ID = "messageID";
    public static final String EVENT_ID_PUSH_TRANSMIT = "push_transmit";
    public static final String EVENT_ID_PUSH_SHOW = "push_show";
    public static final String EVENT_ID_PUSH_NO_SHOW = "push_no_show";
    public static final String EVENT_ID_PUSH_CLICK = "push_click";
    public static final String EVENT_ID_PUSH_EXCEPTION = "push_exception";
    public static final String EVENT_ID_PUSH_DELETE = "push_delete";
    private static final String SUPPORT_OPEN_PUSH = "supportOpenPush";
    private List<com.coloros.mcssdk.b.c> mProcessors = new ArrayList<com.coloros.mcssdk.b.c>();
    private List<d> mParsers = new ArrayList<d>();
    private String mAppKey;
    private String mAppSecret;
    private String mRegisterID;
    private PushCallback mPushCallback;
    private static int count = 0;

    private synchronized void addProcessor(com.coloros.mcssdk.b.c c2) {
        if (c2 != null) {
            this.mProcessors.add(c2);
        }
    }

    private synchronized void addParser(d d2) {
        if (d2 != null) {
            this.mParsers.add(d2);
        }
    }

    public List<d> getParsers() {
        return this.mParsers;
    }

    public List<com.coloros.mcssdk.b.c> getProcessors() {
        return this.mProcessors;
    }

    public static PushManager getInstance() {
        return c.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PushManager() {
        Class<PushManager> clazz = PushManager.class;
        synchronized (PushManager.class) {
            if (count > 0) {
                throw new RuntimeException("PushManager can't create again!");
            }
            ++count;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.addParser(new com.coloros.mcssdk.a.a());
            this.addParser(new com.coloros.mcssdk.a.e());
            this.addParser(new com.coloros.mcssdk.a.b());
            this.addProcessor(new a());
            this.addProcessor(new com.coloros.mcssdk.b.d());
            this.addProcessor(new com.coloros.mcssdk.b.b());
            return;
        }
    }

    private void checkContext() {
        if (this.mContext == null) {
            throw new IllegalArgumentException("please call the register first!");
        }
    }

    private void checkRegisterID() {
        if (this.mRegisterID == null) {
            throw new IllegalArgumentException("please call the register until get the registerID!");
        }
    }

    private void checkAll() {
        this.checkContext();
        this.checkRegisterID();
    }

    public void setAppKeySecret(String string, String string2) {
        this.mAppKey = string;
        this.mAppSecret = string2;
    }

    public void setRegisterID(String string) {
        this.mRegisterID = string;
    }

    private void startMcsService(int n) {
        this.startMcsService(n, "");
    }

    private void startMcsService(int n, String string) {
        Intent intent = new Intent();
        intent.setAction(MCS_RECEIVE_SDK_ACTION);
        intent.setPackage(MCS_PACKAGE);
        intent.putExtra(TYPE, n);
        intent.putExtra("params", string);
        intent.putExtra(APP_PACKAGE, this.mContext.getPackageName());
        intent.putExtra("appKey", this.mAppKey);
        intent.putExtra("appSecret", this.mAppSecret);
        intent.putExtra("registerID", this.mRegisterID);
        intent.putExtra("sdkVersion", this.getSDKVersion());
        this.mContext.startService(intent);
    }

    public PushCallback getPushCallback() {
        return this.mPushCallback;
    }

    public void setPushCallback(PushCallback pushCallback) {
        this.mPushCallback = pushCallback;
    }

    public static boolean isSupportPush(Context context) {
        return e.a(context, MCS_PACKAGE) && e.b(context, MCS_PACKAGE) >= 1012 && e.a(context, MCS_PACKAGE, SUPPORT_OPEN_PUSH);
    }

    public void register(Context context, String string, String string2, PushCallback pushCallback) {
        if (context == null) {
            throw new IllegalArgumentException("context is null !");
        }
        if (!PushManager.isSupportPush(context)) {
            throw new IllegalArgumentException("the phone is not support oppo push!");
        }
        this.mAppKey = string;
        this.mAppSecret = string2;
        this.mContext = context.getApplicationContext();
        this.mPushCallback = pushCallback;
        this.startMcsService(12289);
    }

    public void unRegister() {
        this.checkAll();
        this.startMcsService(12290);
    }

    public void getRegister() {
        this.checkContext();
        this.startMcsService(12289);
    }

    public void setAliases(List<String> list) {
        this.checkAll();
        if (list == null || list.size() == 0) {
            return;
        }
        this.startMcsService(12292, CommandMessage.parseToString(list));
    }

    public void unsetAlias(String string) {
        this.checkAll();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.unsetAliases(arrayList);
    }

    @Deprecated
    public void unsetAliases(List<String> list) {
        this.checkAll();
        if (list == null || list.size() == 0) {
            return;
        }
        this.startMcsService(12294, CommandMessage.parseToString(list));
    }

    public void getAliases() {
        this.checkAll();
        this.startMcsService(12293);
    }

    public void setUserAccount(String string) {
        this.checkAll();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.setUserAccounts(arrayList);
    }

    @Deprecated
    public void setUserAccounts(List<String> list) {
        this.checkAll();
        if (list == null || list.size() == 0) {
            return;
        }
        this.startMcsService(12301, CommandMessage.parseToString(list));
    }

    public void unsetUserAccounts(List<String> list) {
        this.checkAll();
        if (list == null || list.size() == 0) {
            return;
        }
        this.startMcsService(12303, CommandMessage.parseToString(list));
    }

    public void getUserAccounts() {
        this.checkAll();
        this.startMcsService(12302);
    }

    public void setTags(List<String> list) {
        this.checkAll();
        if (list == null || list.size() == 0) {
            return;
        }
        this.startMcsService(12295, CommandMessage.parseToString(list));
    }

    public void unsetTags(List<String> list) {
        this.checkAll();
        if (list == null || list.size() == 0) {
            return;
        }
        this.startMcsService(12297, CommandMessage.parseToString(list));
    }

    public void getTags() {
        this.checkAll();
        this.startMcsService(12296);
    }

    public void pausePush() {
        this.checkAll();
        this.startMcsService(12299);
    }

    public void resumePush() {
        this.checkAll();
        this.startMcsService(12300);
    }

    public void getNotificationStatus() {
        this.checkAll();
        this.startMcsService(12309);
    }

    public void setNotificationType(int n) {
        this.checkAll();
        this.startMcsService(12307, String.valueOf(n));
    }

    public void clearNotificationType() {
        this.checkAll();
        this.startMcsService(12308);
    }

    public void openNotificationSettings() {
        this.checkAll();
        this.startMcsService(12310);
    }

    public void getPushStatus() {
        this.checkAll();
        this.startMcsService(12306);
    }

    public String getSDKVersion() {
        return VERSION;
    }

    public String getPushVersionName() {
        this.checkContext();
        return e.c(this.mContext, MCS_PACKAGE);
    }

    public int getPushVersionCode() {
        this.checkContext();
        return e.b(this.mContext, MCS_PACKAGE);
    }

    public void setPushTime(List<Integer> list, int n, int n2, int n3, int n4) {
        this.checkAll();
        if (list != null && list.size() > 0 && n >= 0 && n <= 23 && n2 >= 0 && n2 <= 59 && n3 >= n && n3 <= 23 && n4 >= n2 && n4 <= 59) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("weekDays", (Object)CommandMessage.parseToString(list));
                jSONObject.put("startHour", n);
                jSONObject.put("startMin", n2);
                jSONObject.put("endHour", n3);
                jSONObject.put("endMin", n4);
                this.startMcsService(12298, jSONObject.toString());
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return;
            }
        }
        throw new IllegalArgumentException("params are not all right,please check params");
    }

    public void getPushTime() {
        this.checkAll();
        this.startMcsService(12298);
    }

    public static void statisticMessage(Context context, AppMessage appMessage, String string) {
        try {
            Intent intent = new Intent();
            intent.setAction(MCS_RECEIVE_SDK_ACTION);
            intent.setPackage(MCS_PACKAGE);
            intent.putExtra(TYPE, 12291);
            intent.putExtra(TASK_ID, appMessage.getTaskID());
            intent.putExtra(APP_PACKAGE, appMessage.getAppPackage());
            intent.putExtra(MESSAGE_ID, "" + appMessage.getMessageID());
            intent.putExtra(MESSAGE_TYPE, appMessage.getType());
            intent.putExtra(EVENT_ID, string);
            context.startService(intent);
            return;
        }
        catch (Exception exception) {
            com.coloros.mcssdk.c.d.b("statisticMessage--Exception" + exception.getMessage());
            return;
        }
    }

    public static void statisticMessage(Context context, SptDataMessage sptDataMessage, String string) {
        try {
            Intent intent = new Intent();
            intent.setAction(MCS_RECEIVE_SDK_ACTION);
            intent.setPackage(MCS_PACKAGE);
            intent.putExtra(TYPE, 12291);
            intent.putExtra(TASK_ID, sptDataMessage.getTaskID());
            intent.putExtra(APP_PACKAGE, sptDataMessage.getAppPackage());
            intent.putExtra(MESSAGE_ID, "" + sptDataMessage.getMessageID());
            intent.putExtra(MESSAGE_TYPE, sptDataMessage.getType());
            intent.putExtra(EVENT_ID, string);
            context.startService(intent);
            return;
        }
        catch (Exception exception) {
            com.coloros.mcssdk.c.d.b("statisticMessage--Exception" + exception.getMessage());
            return;
        }
    }

    /* synthetic */ PushManager(b b2) {
        this();
    }
}

