/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.network;

import android.text.TextUtils;
import com.xiaomi.network.Fallback;
import com.xiaomi.network.HostManager;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Fallbacks {
    private String host;
    private final ArrayList<Fallback> mFallbacks = new ArrayList();

    public Fallbacks(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("the host is empty");
        }
        this.host = string;
    }

    public Fallbacks() {
    }

    public synchronized void addFallback(Fallback fallback) {
        int n2;
        for (n2 = 0; n2 < this.mFallbacks.size(); ++n2) {
            if (!this.mFallbacks.get(n2).a(fallback)) continue;
            this.mFallbacks.set(n2, fallback);
            break;
        }
        if (n2 >= this.mFallbacks.size()) {
            this.mFallbacks.add(fallback);
        }
    }

    public synchronized Fallback getFallback() {
        for (int i2 = this.mFallbacks.size() - 1; i2 >= 0; --i2) {
            Fallback fallback = this.mFallbacks.get(i2);
            if (!fallback.a()) continue;
            HostManager.getInstance().setCurrentISP(fallback.e());
            return fallback;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.host);
        stringBuilder.append("\n");
        for (Fallback fallback : this.mFallbacks) {
            stringBuilder.append(fallback);
        }
        return stringBuilder.toString();
    }

    public ArrayList<Fallback> getFallbacks() {
        return this.mFallbacks;
    }

    public synchronized void purge(boolean bl2) {
        for (int i2 = this.mFallbacks.size() - 1; i2 >= 0; --i2) {
            Fallback fallback = this.mFallbacks.get(i2);
            if (bl2) {
                if (!fallback.c()) continue;
                this.mFallbacks.remove(i2);
                continue;
            }
            if (fallback.b()) continue;
            this.mFallbacks.remove(i2);
        }
    }

    public String getHost() {
        return this.host;
    }

    public synchronized JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("host", (Object)this.host);
        JSONArray jSONArray = new JSONArray();
        for (Fallback fallback : this.mFallbacks) {
            jSONArray.put((Object)fallback.f());
        }
        jSONObject.put("fbs", (Object)jSONArray);
        return jSONObject;
    }

    public synchronized Fallbacks fromJSON(JSONObject jSONObject) {
        this.host = jSONObject.getString("host");
        JSONArray jSONArray = jSONObject.getJSONArray("fbs");
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            this.mFallbacks.add(new Fallback(this.host).a(jSONArray.getJSONObject(i2)));
        }
        return this;
    }
}

