/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import com.xiaomi.clientreport.data.Config;
import com.xiaomi.clientreport.manager.ClientReportClient;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.MiTinyDataClient;
import com.xiaomi.mipush.sdk.PushConfiguration;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.af;
import com.xiaomi.mipush.sdk.ag;
import com.xiaomi.mipush.sdk.aq;
import com.xiaomi.mipush.sdk.av;
import com.xiaomi.mipush.sdk.aw;
import com.xiaomi.mipush.sdk.b;
import com.xiaomi.mipush.sdk.d;
import com.xiaomi.mipush.sdk.e;
import com.xiaomi.mipush.sdk.h;
import com.xiaomi.mipush.sdk.q;
import com.xiaomi.mipush.sdk.r;
import com.xiaomi.mipush.sdk.v;
import com.xiaomi.mipush.sdk.x;
import com.xiaomi.push.ai;
import com.xiaomi.push.au;
import com.xiaomi.push.bf;
import com.xiaomi.push.dq;
import com.xiaomi.push.dr;
import com.xiaomi.push.ey;
import com.xiaomi.push.ez;
import com.xiaomi.push.fa;
import com.xiaomi.push.fg;
import com.xiaomi.push.g;
import com.xiaomi.push.hm;
import com.xiaomi.push.hq;
import com.xiaomi.push.hr;
import com.xiaomi.push.hw;
import com.xiaomi.push.hz;
import com.xiaomi.push.i;
import com.xiaomi.push.ia;
import com.xiaomi.push.ig;
import com.xiaomi.push.il;
import com.xiaomi.push.im;
import com.xiaomi.push.iq;
import com.xiaomi.push.is;
import com.xiaomi.push.iu;
import com.xiaomi.push.l;
import com.xiaomi.push.m;
import com.xiaomi.push.n;
import com.xiaomi.push.service.ak;
import com.xiaomi.push.service.an;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import com.xiaomi.push.t;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_UNREGISTER = "unregister";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static boolean isCrashHandlerSuggested = false;
    private static Context sContext;
    private static long sCurMsgId;

    public static boolean shouldUseMIUIPush(Context context) {
        return aq.a(context).a();
    }

    public static void registerPush(Context context, String string, String string2) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration());
    }

    public static void registerPush(Context context, String string, String string2, String string3) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), string3, null);
    }

    public static void registerPush(Context context, String string, String string2, PushConfiguration pushConfiguration) {
        MiPushClient.registerPush(context, string, string2, pushConfiguration, null, null);
    }

    private static void registerPush(Context context, final String string, final String string2, PushConfiguration pushConfiguration, final String string3, final ICallbackResult iCallbackResult) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        sContext = context.getApplicationContext();
        if (sContext == null) {
            sContext = context;
        }
        context = sContext;
        t.a(context);
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(sContext);
        }
        e.a(sContext).a(pushConfiguration);
        ai.a(context).a(new Runnable(){

            @Override
            public void run() {
                MiPushClient.initialize(sContext, string, string2, null, string3, iCallbackResult);
            }
        });
    }

    private static boolean checkPermission(Context context) {
        String string;
        String[] stringArray;
        boolean bl2 = false;
        if (context != null) {
            if (l.a() || "com.xiaomi.xmsf".equals(context.getPackageName())) {
                bl2 = true;
            } else if (!TextUtils.isEmpty((CharSequence)i.b(context))) {
                bl2 = true;
            } else {
                int n2 = context.getApplicationInfo().targetSdkVersion;
                if (n2 >= 23 && Build.VERSION.SDK_INT >= 23) {
                    if (m.a(context, "android.permission.READ_PHONE_STATE") || m.a(context, "android.permission.WRITE_EXTERNAL_STORAGE") || au.a(context).a()) {
                        bl2 = true;
                    }
                } else {
                    stringArray = i.f(context);
                    string = i.a();
                    if (!TextUtils.isEmpty((CharSequence)stringArray) || !TextUtils.isEmpty((CharSequence)string)) {
                        bl2 = true;
                    }
                }
            }
        }
        if (!bl2) {
            com.xiaomi.channel.commonutils.logger.b.d("Because of lack of necessary information, mi push can't be initialized");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!m.a(context, "android.permission.READ_PHONE_STATE")) {
                arrayList.add("android.permission.READ_PHONE_STATE");
            }
            if (!m.a(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                arrayList.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            if (!arrayList.isEmpty()) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                string = new Intent();
                string.setAction("com.xiaomi.mipush.ERROR");
                string.setPackage(context.getPackageName());
                string.putExtra("message_type", 5);
                string.putExtra("error_type", "error_lack_of_permission");
                string.putExtra("error_message", stringArray);
                context.sendBroadcast((Intent)string);
            }
        }
        return bl2;
    }

    private static void registerNetworkReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addCategory("android.intent.category.DEFAULT");
            Context context2 = context.getApplicationContext();
            context2.registerReceiver((BroadcastReceiver)new NetworkStatusReceiver(null), intentFilter);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    @Deprecated
    public static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.initialize(context, string, string2, miPushClientCallback, null, null);
    }

    private static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback, String string3, ICallbackResult iCallbackResult) {
        try {
            boolean bl2;
            com.xiaomi.channel.commonutils.logger.b.a("sdk_version = 3_7_5");
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (iCallbackResult != null) {
                PushMessageHandler.a(iCallbackResult);
            }
            if (t.a(sContext)) {
                x.a(sContext);
            }
            if (!b.a(sContext).a(string, string2) && !MiPushClient.checkPermission(sContext)) {
                return;
            }
            boolean bl3 = bl2 = b.a(sContext).a() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                aq.a(sContext).a();
                com.xiaomi.channel.commonutils.logger.b.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && b.a(sContext).a(string, string2) && !b.a(sContext).e()) {
                Object object;
                Object object2;
                if (1 == PushMessageHelper.getPushMode(sContext)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, b.a(sContext).c());
                } else {
                    object2 = new ArrayList<String>();
                    object2.add(b.a(sContext).c());
                    object = PushMessageHelper.generateCommandMessage(fg.a.a, object2, 0L, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object);
                }
                aq.a(sContext).a();
                if (b.a(sContext).a()) {
                    object2 = new il();
                    ((il)object2).b(b.a(sContext).a());
                    ((il)object2).c("client_info_update");
                    ((il)object2).a(an.a());
                    ((il)object2).a = new HashMap();
                    ((il)object2).a.put("app_version", g.a(sContext, sContext.getPackageName()));
                    ((il)object2).a.put("app_version_code", Integer.toString(g.a(sContext, sContext.getPackageName())));
                    ((il)object2).a.put("push_sdk_vn", "3_7_5");
                    ((il)object2).a.put("push_sdk_vc", Integer.toString(30705));
                    object = b.a(sContext).e();
                    if (!TextUtils.isEmpty((CharSequence)object)) {
                        ((il)object2).a.put("deviceid", object);
                    }
                    aq.a(sContext).a(object2, hm.i, false, null);
                }
                if (!n.a(sContext, "update_devId", false)) {
                    MiPushClient.updateImeiOrOaid();
                    n.a(sContext, "update_devId", true);
                }
                if (!TextUtils.isEmpty((CharSequence)(object2 = i.d(sContext)))) {
                    object = new ig();
                    ((ig)object).a(an.a());
                    ((ig)object).b(string);
                    ((ig)object).c(fg.j.a);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(i.c(sContext));
                    arrayList.add((String)object2);
                    arrayList.add(Build.MODEL != null ? Build.MODEL : "");
                    arrayList.add(Build.BOARD != null ? Build.BOARD : "");
                    ((ig)object).a(arrayList);
                    aq.a(sContext).a(object, hm.j, false, null);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    object = new il();
                    ((il)object).b(b.a(sContext).a());
                    ((il)object).c(hw.j.a);
                    ((il)object).a(an.a());
                    ((il)object).a(false);
                    aq.a(sContext).a(object, hm.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                String string4;
                String string5 = bf.a(6);
                b.a(sContext).a();
                b.a(sContext).a(Constants.a());
                b.a(sContext).a(string, string2, string5);
                MiTinyDataClient.a.a().b("com.xiaomi.xmpushsdk.tinydataPending.appId");
                MiPushClient.clearExtras(sContext);
                im im2 = new im();
                im2.a(an.a());
                im2.b(string);
                im2.e(string2);
                im2.d(sContext.getPackageName());
                im2.f(string5);
                im2.c(g.a(sContext, sContext.getPackageName()));
                im2.b(g.a(sContext, sContext.getPackageName()));
                im2.h("3_7_5");
                im2.a(30705);
                im2.i(i.e(sContext));
                im2.a(ia.c);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    im2.g(string3);
                }
                if (!l.d() && !TextUtils.isEmpty((CharSequence)(string4 = i.g(sContext)))) {
                    im2.k(bf.a(string4) + "," + i.j(sContext));
                }
                im2.j(i.a());
                int n2 = i.a();
                if (n2 >= 0) {
                    im2.c(n2);
                }
                aq.a(sContext).a(im2, bl2);
                sContext.getSharedPreferences(PREF_EXTRA, 4).getBoolean("mipush_registed", true);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleDataCollectionJobs(sContext);
            MiPushClient.initEventPerfLogic(sContext);
            aw.a(sContext);
            MiPushClient.forceHandleCrash();
            if (!sContext.getPackageName().equals("com.xiaomi.xmsf")) {
                if (Logger.getUserLogger() != null) {
                    Logger.setLogger(sContext, Logger.getUserLogger());
                }
                com.xiaomi.channel.commonutils.logger.b.a(2);
            }
            MiPushClient.operateSyncAction(context);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = ak.a(sContext).a(hr.A.a(), 86400);
        ai.a(sContext).a(new af(sContext), n2, 5);
    }

    private static void scheduleDataCollectionJobs(Context context) {
        int n2 = hr.z.a();
        if (ak.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            dq.a().a(new q(context));
            ai.a(sContext).a(new Runnable(){

                @Override
                public void run() {
                    dr.a(sContext);
                }
            }, 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return l.b();
    }

    private static void updateImeiOrOaid() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!l.d() && (i.f(sContext) != null || au.a(sContext).a())) {
                    il il2 = new il();
                    il2.b(b.a(sContext).a());
                    il2.c("client_info_update");
                    il2.a(an.a());
                    il2.a(new HashMap<String, String>());
                    String string = "";
                    String string2 = i.f(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        string = string + bf.a(string2);
                    }
                    String string3 = i.h(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string3)) {
                        string = string + "," + string3;
                    }
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        il2.a().put("imei_md5", string);
                    }
                    au.a(sContext).a(il2.a());
                    int n2 = i.a();
                    if (n2 >= 0) {
                        il2.a().put("space_id", Integer.toString(n2));
                    }
                    aq.a(sContext).a(il2, hm.i, false, null);
                }
            }
        }).start();
    }

    public static void awakeApps(final Context context, final String[] stringArray) {
        ai.a(context).a(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String string : stringArray) {
                        PackageInfo packageInfo;
                        if (TextUtils.isEmpty((CharSequence)string) || (packageInfo = context.getPackageManager().getPackageInfo(string, 4)) == null) continue;
                        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
                    }
                }
                catch (Throwable throwable) {
                    com.xiaomi.channel.commonutils.logger.b.a(throwable);
                }
            }
        });
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    PushMessageHandler.a(context, intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    static void reInitialize(Context context, ia ia2) {
        if (!b.a(context).c()) {
            return;
        }
        String string = bf.a(6);
        String string2 = b.a(context).a();
        String string3 = b.a(context).b();
        b.a(context).a();
        b.a(context).a(Constants.a());
        b.a(context).a(string2, string3, string);
        im im2 = new im();
        im2.a(an.a());
        im2.b(string2);
        im2.e(string3);
        im2.f(string);
        im2.d(context.getPackageName());
        im2.c(g.a(context, context.getPackageName()));
        im2.a(ia2);
        aq.a(context).a(im2, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        hz hz2 = new hz();
        hz2.a(miPushMessage.getMessageId());
        hz2.b(miPushMessage.getTopic());
        hz2.d(miPushMessage.getDescription());
        hz2.c(miPushMessage.getTitle());
        hz2.c(miPushMessage.getNotifyId());
        hz2.a(miPushMessage.getNotifyType());
        hz2.b(miPushMessage.getPassThrough());
        hz2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), hz2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, hz hz2, String string2) {
        il il2 = new il();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!b.a(context).b()) {
                com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
                return;
            }
            il2.b(b.a(context).a());
        } else {
            il2.b(string2);
        }
        il2.c("bar:click");
        il2.a(string);
        il2.a(false);
        aq.a(context).a(il2, hm.i, false, hz2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, hz hz2, String string2, String string3) {
        il il2 = new il();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
            return;
        }
        il2.b(string3);
        il2.c("bar:click");
        il2.a(string);
        il2.a(false);
        aq.a(context).a(il2, hm.i, false, true, hz2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        aq.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        aq.a(context).e();
    }

    public static void unregisterPush(Context context) {
        h.c(context);
        ak.a(context).a();
        if (!b.a(context).b()) {
            return;
        }
        is is2 = new is();
        is2.a(an.a());
        is2.b(b.a(context).a());
        is2.c(b.a(context).c());
        is2.e(b.a(context).b());
        is2.d(context.getPackageName());
        aq.a(context).a(is2);
        PushMessageHandler.a();
        PushMessageHandler.b();
        b.a(context).b();
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        MiPushClient.clearExtras(context);
    }

    public static void disablePush(Context context) {
        aq.a(context).a(true);
    }

    public static void enablePush(Context context) {
        aq.a(context).a(false);
    }

    public static void syncAssemblePushToken(Context context) {
        aq.a(context).a(null, av.c, d.a);
    }

    public static void syncAssembleFCMPushToken(Context context) {
        aq.a(context).a(null, av.d, d.b);
    }

    public static void syncAssembleCOSPushToken(Context context) {
        aq.a(context).a(null, av.e, d.c);
    }

    public static void syncAssembleFTOSPushToken(Context context) {
        aq.a(context).a(null, av.f, d.d);
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, fg.c.a, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, fg.d.a, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, fg.e.a, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, fg.f.a, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            iq iq2 = new iq();
            iq2.a(an.a());
            iq2.b(b.a(context).a());
            iq2.c(string);
            iq2.d(context.getPackageName());
            iq2.e(string2);
            aq.a(context).a(iq2, hm.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fg.g.a, arrayList, 0L, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!b.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel subscribe for " + string + " is unsubscribed");
            return;
        }
        iu iu2 = new iu();
        iu2.a(an.a());
        iu2.b(b.a(context).a());
        iu2.c(string);
        iu2.d(context.getPackageName());
        iu2.e(string2);
        aq.a(context).a(iu2, hm.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        aq.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        aq.a(context).a(string, string2);
    }

    public static void clearNotification(Context context) {
        aq.a(context).a(-1);
    }

    public static void reportAppRunInBackground(Context context, boolean bl2) {
        if (!b.a(context).b()) {
            return;
        }
        hw hw2 = bl2 ? hw.Q : hw.P;
        il il2 = new il();
        il2.b(b.a(context).a());
        il2.c(hw2.a);
        il2.d(context.getPackageName());
        il2.a(an.a());
        il2.a(false);
        aq.a(context).a(il2, hm.i, false, null, false);
    }

    public static String getRegId(Context context) {
        if (b.a(context).c()) {
            return b.a(context).c();
        }
        return null;
    }

    public static String getAppRegion(Context context) {
        if (b.a(context).c()) {
            return b.a(context).f();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (fg.c.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 86400000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fg.c.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (fg.d.a.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel alias for " + bf.a(arrayList.toString(), 3) + " is unseted");
        } else if (fg.e.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fg.e.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (fg.f.a.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel account for " + bf.a(arrayList.toString(), 3) + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a())) {
            return;
        }
        ig ig2 = new ig();
        ig2.a(an.a());
        ig2.b(b.a(context).a());
        ig2.c(string);
        for (String string3 : arrayList) {
            ig2.a(string3);
        }
        ig2.e(string2);
        ig2.d(context.getPackageName());
        aq.a(context).a(ig2, hm.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, fg.i.a, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(fg.i.a, arrayList2, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, fg.i.a, arrayList, string);
        }
    }

    protected static boolean getOpenHmsPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.a);
    }

    protected static boolean getOpenFCMPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.b);
    }

    protected static boolean getOpenOPPOPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.c);
    }

    protected static boolean getOpenVIVOPush(Context context) {
        return e.a(context).b(d.d);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("accept_time", string + "," + string2);
        com.xiaomi.push.r.a(editor);
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("accept_time");
        com.xiaomi.push.r.a(editor);
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_pull_notification", System.currentTimeMillis());
        com.xiaomi.push.r.a(editor);
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_reg_request", System.currentTimeMillis());
        com.xiaomi.push.r.a(editor);
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    private static void initEventPerfLogic(final Context context) {
        fa.a(new fa.a(){

            @Override
            public void uploader(Context context, hq hq2) {
                MiTinyDataClient.upload(context, hq2);
            }
        });
        Config config = fa.a(context);
        com.xiaomi.clientreport.manager.a.a(context).a("3_7_5");
        ClientReportClient.init(context, config, new ey(context), new ez(context));
        a.a(context);
        r.a(context, config);
        ak.a(context).a(new ak.a(100, "perf event job update"){

            @Override
            protected void onCallback() {
                fa.a(context);
            }
        });
    }

    public static void registerCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(new v(sContext, uncaughtExceptionHandler));
        isCrashHandlerSuggested = true;
    }

    private static void forceHandleCrash() {
        boolean bl2 = ak.a(sContext).a(hr.av.a(), false);
        if (!isCrashHandlerSuggested && bl2) {
            Thread.setDefaultUncaughtExceptionHandler(new v(sContext));
        }
    }

    private static void operateSyncAction(Context context) {
        if ("syncing".equals(ag.a(sContext).a(av.a))) {
            MiPushClient.disablePush(sContext);
        }
        if ("syncing".equals(ag.a(sContext).a(av.b))) {
            MiPushClient.enablePush(sContext);
        }
        if ("syncing".equals(ag.a(sContext).a(av.c))) {
            MiPushClient.syncAssemblePushToken(sContext);
        }
        if ("syncing".equals(ag.a(sContext).a(av.d))) {
            MiPushClient.syncAssembleFCMPushToken(sContext);
        }
        if ("syncing".equals(ag.a(sContext).a(av.e))) {
            MiPushClient.syncAssembleCOSPushToken(context);
        }
        if ("syncing".equals(ag.a(sContext).a(av.f))) {
            MiPushClient.syncAssembleFTOSPushToken(context);
        }
    }

    public static void registerToken(Context context, String string, String string2, String string3, UPSRegisterCallBack uPSRegisterCallBack) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), null, uPSRegisterCallBack);
    }

    public static void unRegisterToken(Context context, UPSUnRegisterCallBack uPSUnRegisterCallBack) {
        MiPushClient.unregisterPush(context);
        if (uPSUnRegisterCallBack != null) {
            TokenResult tokenResult = new TokenResult();
            tokenResult.setToken(null);
            tokenResult.getToken();
            tokenResult.setResultCode(0L);
            tokenResult.getResultCode();
            uPSUnRegisterCallBack.onResult(tokenResult);
        }
    }

    public static void turnOnPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.enablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    public static void turnOffPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.disablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    public static class CodeResult {
        private long resultCode = -1L;

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static class TokenResult {
        private String token = null;
        private long resultCode = -1L;

        protected void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static interface UPSTurnCallBack
    extends ICallbackResult<CodeResult> {
    }

    public static interface UPSUnRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface UPSRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface ICallbackResult<R> {
        public void onResult(R var1);
    }

    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

