/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.AlterClientQuotasResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.quota.ClientQuotaEntity;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ApiError;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlterClientQuotasResponse
extends AbstractResponse {
    private final AlterClientQuotasResponseData data;

    public AlterClientQuotasResponse(Map<ClientQuotaEntity, ApiError> result, int throttleTimeMs) {
        ArrayList<AlterClientQuotasResponseData.EntryData> entries = new ArrayList<AlterClientQuotasResponseData.EntryData>(result.size());
        for (Map.Entry<ClientQuotaEntity, ApiError> entry : result.entrySet()) {
            ApiError e = entry.getValue();
            entries.add(new AlterClientQuotasResponseData.EntryData().setErrorCode(e.error().code()).setErrorMessage(e.message()).setEntity(AlterClientQuotasResponse.toEntityData(entry.getKey())));
        }
        this.data = new AlterClientQuotasResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entries);
    }

    public AlterClientQuotasResponse(Collection<ClientQuotaEntity> entities, int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<AlterClientQuotasResponseData.EntryData> entries = new ArrayList<AlterClientQuotasResponseData.EntryData>(entities.size());
        for (ClientQuotaEntity entity : entities) {
            entries.add(new AlterClientQuotasResponseData.EntryData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setEntity(AlterClientQuotasResponse.toEntityData(entity)));
        }
        this.data = new AlterClientQuotasResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entries);
    }

    public AlterClientQuotasResponse(Struct struct, short version) {
        this.data = new AlterClientQuotasResponseData(struct, version);
    }

    public void complete(Map<ClientQuotaEntity, KafkaFutureImpl<Void>> futures) {
        for (AlterClientQuotasResponseData.EntryData entryData : this.data.entries()) {
            HashMap<String, String> entityEntries = new HashMap<String, String>(entryData.entity().size());
            for (AlterClientQuotasResponseData.EntityData entityData : entryData.entity()) {
                entityEntries.put(entityData.entityType(), entityData.entityName());
            }
            ClientQuotaEntity entity = new ClientQuotaEntity(entityEntries);
            KafkaFutureImpl<Void> future = futures.get(entity);
            if (future == null) {
                throw new IllegalArgumentException("Future map must contain entity " + entity);
            }
            Errors error = Errors.forCode(entryData.errorCode());
            if (error == Errors.NONE) {
                future.complete(null);
                continue;
            }
            future.completeExceptionally(error.exception(entryData.errorMessage()));
        }
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.entries().forEach(entry -> this.updateErrorCounts(counts, Errors.forCode(entry.errorCode())));
        return counts;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    private static List<AlterClientQuotasResponseData.EntityData> toEntityData(ClientQuotaEntity entity) {
        ArrayList<AlterClientQuotasResponseData.EntityData> entityData = new ArrayList<AlterClientQuotasResponseData.EntityData>(entity.entries().size());
        for (Map.Entry<String, String> entry : entity.entries().entrySet()) {
            entityData.add(new AlterClientQuotasResponseData.EntityData().setEntityType(entry.getKey()).setEntityName(entry.getValue()));
        }
        return entityData;
    }

    public static AlterClientQuotasResponse parse(ByteBuffer buffer, short version) {
        return new AlterClientQuotasResponse(ApiKeys.ALTER_CLIENT_QUOTAS.parseResponse(version, buffer), version);
    }
}

