/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.Message;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.TaskStateType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class TasksRequest
extends Message {
    private final Set<String> taskIds;
    private final long firstStartMs;
    private final long lastStartMs;
    private final long firstEndMs;
    private final long lastEndMs;
    private final Optional<TaskStateType> state;

    @JsonCreator
    public TasksRequest(@JsonProperty(value="taskIds") Collection<String> taskIds, @JsonProperty(value="firstStartMs") long firstStartMs, @JsonProperty(value="lastStartMs") long lastStartMs, @JsonProperty(value="firstEndMs") long firstEndMs, @JsonProperty(value="lastEndMs") long lastEndMs, @JsonProperty(value="state") Optional<TaskStateType> state) {
        this.taskIds = Collections.unmodifiableSet(taskIds == null ? new HashSet() : new HashSet<String>(taskIds));
        this.firstStartMs = Math.max(0L, firstStartMs);
        this.lastStartMs = Math.max(0L, lastStartMs);
        this.firstEndMs = Math.max(0L, firstEndMs);
        this.lastEndMs = Math.max(0L, lastEndMs);
        this.state = state == null ? Optional.empty() : state;
    }

    @JsonProperty
    public Collection<String> taskIds() {
        return this.taskIds;
    }

    @JsonProperty
    public long firstStartMs() {
        return this.firstStartMs;
    }

    @JsonProperty
    public long lastStartMs() {
        return this.lastStartMs;
    }

    @JsonProperty
    public long firstEndMs() {
        return this.firstEndMs;
    }

    @JsonProperty
    public long lastEndMs() {
        return this.lastEndMs;
    }

    @JsonProperty
    public Optional<TaskStateType> state() {
        return this.state;
    }

    public boolean matches(String taskId, long startMs, long endMs, TaskStateType state) {
        if (!this.taskIds.isEmpty() && !this.taskIds.contains(taskId)) {
            return false;
        }
        if (this.firstStartMs > 0L && startMs < this.firstStartMs) {
            return false;
        }
        if (this.lastStartMs > 0L && (startMs < 0L || startMs > this.lastStartMs)) {
            return false;
        }
        if (this.firstEndMs > 0L && endMs < this.firstEndMs) {
            return false;
        }
        if (this.lastEndMs > 0L && (endMs < 0L || endMs > this.lastEndMs)) {
            return false;
        }
        return !this.state.isPresent() || this.state.get().equals((Object)state);
    }
}

