/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.sqlserver.LegacyV1SqlServerSourceInfoStructMaker;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SourceTimestampMode;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerSourceInfoStructMaker;
import io.debezium.document.Document;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorConfig.class);
    public static final String SOURCE_TIMESTAMP_MODE_CONFIG_NAME = "source.timestamp.mode";
    protected static final int DEFAULT_PORT = 1433;
    private static final String READ_ONLY_INTENT = "ReadOnly";
    private static final String APPLICATION_INTENT_KEY = "database.applicationIntent";
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(1433);
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName);
    public static final Field INSTANCE = Field.create("database.instance").withDisplayName("Instance name").withType(ConfigDef.Type.STRING).withImportance(ConfigDef.Importance.LOW).withValidation(Field::isOptional).withDescription("The SQL Server instance name");
    public static final Field SERVER_TIMEZONE = Field.create("database.server.timezone").withDisplayName("Server timezone").withType(ConfigDef.Type.STRING).withImportance(ConfigDef.Importance.LOW).withValidation((config, field, problems) -> {
        String value = config.getString(field);
        if (value != null) {
            try {
                ZoneId.of(value, ZoneId.SHORT_IDS);
            }
            catch (DateTimeException e) {
                problems.accept(field, value, "The value must be a valid ZoneId");
                return 1;
            }
        }
        return 0;
    }).withDescription("The timezone of the server used to correctly shift the commit transaction timestamp on the client sideOptions include: Any valid Java ZoneId");
    public static final Field MAX_LSN_OPTIMIZATION = Field.createInternal("streaming.lsn.optimization").withDisplayName("Max LSN Optimization").withDefault(true).withType(ConfigDef.Type.BOOLEAN).withImportance(ConfigDef.Importance.LOW).withDescription("This property can be used to enable/disable an optimization that prevents querying the cdc tables on LSNs not correlated to changes.");
    public static final Field SOURCE_TIMESTAMP_MODE = Field.create("source.timestamp.mode").withDisplayName("Source timestamp mode").withDefault(SourceTimestampMode.COMMIT.getValue()).withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Configures the criteria of the attached timestamp within the source record (ts_ms).Options include:'" + SourceTimestampMode.COMMIT.getValue() + "', (default) the source timestamp is set to the instant where the record was committed in the database'" + SourceTimestampMode.PROCESSING.getValue() + "', (deprecated) the source timestamp is set to the instant where the record was processed by Debezium.");
    public static final Field SNAPSHOT_MODE = Field.create("snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create("snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, SnapshotIsolationMode.REPEATABLE_READ).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is '" + SnapshotIsolationMode.REPEATABLE_READ.getValue() + "', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of '" + SnapshotIsolationMode.EXCLUSIVE.getValue() + "' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. When '" + SnapshotIsolationMode.SNAPSHOT.getValue() + "' is specified, connector runs the initial snapshot in SNAPSHOT isolation level, which guarantees snapshot consistency. In addition, neither table nor row-level locks are held. When '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' is specified, connector runs the initial snapshot in READ COMMITTED isolation level. No long-running locks are taken, so that initial snapshot does not prevent other transactions from updating table rows. Snapshot consistency is not guaranteed.In '" + SnapshotIsolationMode.READ_UNCOMMITTED.getValue() + "' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.");
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("SQL Server").type(DATABASE_NAME, HOSTNAME, PORT, USER, PASSWORD, SERVER_TIMEZONE, INSTANCE).connector(SNAPSHOT_MODE, SNAPSHOT_ISOLATION_MODE, SOURCE_TIMESTAMP_MODE, MAX_LSN_OPTIMIZATION, BINARY_HANDLING_MODE).excluding(SCHEMA_WHITELIST, SCHEMA_INCLUDE_LIST, SCHEMA_BLACKLIST, SCHEMA_EXCLUDE_LIST).create();
    public static Field.Set ALL_FIELDS = Field.setOf(CONFIG_DEFINITION.all());
    private final String databaseName;
    private final String instanceName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;
    private final SourceTimestampMode sourceTimestampMode;
    private final boolean readOnlyDatabaseConnection;
    private final boolean skipLowActivityLsnsEnabled;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public SqlServerConnectorConfig(Configuration config) {
        super(SqlServerConnector.class, config, config.getString(SERVER_NAME), (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), true, ColumnFilterMode.SCHEMA);
        this.databaseName = config.getString(DATABASE_NAME);
        this.instanceName = config.getString(INSTANCE);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.readOnlyDatabaseConnection = READ_ONLY_INTENT.equals(config.getString(APPLICATION_INTENT_KEY));
        if (this.readOnlyDatabaseConnection) {
            this.snapshotIsolationMode = SnapshotIsolationMode.SNAPSHOT;
            LOGGER.info("JDBC connection has set applicationIntent = ReadOnly, switching snapshot isolation mode to {}", (Object)SnapshotIsolationMode.SNAPSHOT.name());
        } else {
            this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE), SNAPSHOT_ISOLATION_MODE.defaultValueAsString());
        }
        this.sourceTimestampMode = SourceTimestampMode.fromMode(config.getString(SOURCE_TIMESTAMP_MODE_CONFIG_NAME));
        this.skipLowActivityLsnsEnabled = config.getBoolean(MAX_LSN_OPTIMIZATION);
    }

    public Configuration jdbcConfig() {
        return this.getConfig().subset("database.", true);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public SourceTimestampMode getSourceTimestampMode() {
        return this.sourceTimestampMode;
    }

    public boolean isReadOnlyDatabaseConnection() {
        return this.readOnlyDatabaseConnection;
    }

    public boolean isSkipLowActivityLsnsEnabled() {
        return this.skipLowActivityLsnsEnabled;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        switch (version) {
            case V1: {
                return new LegacyV1SqlServerSourceInfoStructMaker(Module.name(), Module.version(), this);
            }
        }
        return new SqlServerSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    @Override
    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            @Override
            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return Lsn.valueOf(recorded.getString("change_lsn")).compareTo(Lsn.valueOf(desired.getString("change_lsn"))) < 1;
            }
        };
    }

    @Override
    public String getContextName() {
        return Module.contextName();
    }

    @Override
    public String getConnectorName() {
        return Module.name();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        @Override
        public boolean isIncluded(TableId t) {
            return !t.schema().toLowerCase().equals("cdc") && !t.schema().toLowerCase().equals("sys") && !t.table().toLowerCase().equals("systranschemas");
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        SNAPSHOT("snapshot"),
        REPEATABLE_READ("repeatable_read"),
        READ_COMMITTED("read_committed"),
        READ_UNCOMMITTED("read_uncommitted");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        INITIAL_ONLY("initial_only", true),
        SCHEMA_ONLY("schema_only", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

