/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import io.debezium.converters.RecordParser;
import io.debezium.converters.SerializerType;
import io.debezium.util.Collect;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;

public abstract class CloudEventsMaker {
    private static final String SCHEMA_URL_PATH = "/schemas/ids/";
    public static final String CLOUDEVENTS_SPECVERSION = "1.0";
    private final SerializerType dataContentType;
    private final String dataSchemaUriBase;
    private final Schema ceDataAttributeSchema;
    protected final RecordParser recordParser;
    static final Map<SerializerType, String> CONTENT_TYPE_NAME_MAP = Collect.hashMapOf(SerializerType.JSON, "application/json", SerializerType.AVRO, "application/avro");

    public static CloudEventsMaker create(RecordParser parser, SerializerType contentType, String dataSchemaUriBase) {
        switch (parser.connectorType()) {
            case "mysql": {
                return new MysqlCloudEventsMaker(parser, contentType, dataSchemaUriBase);
            }
            case "postgresql": {
                return new PostgresCloudEventsMaker(parser, contentType, dataSchemaUriBase);
            }
            case "mongodb": {
                return new MongodbCloudEventsMaker(parser, contentType, dataSchemaUriBase);
            }
            case "sqlserver": {
                return new SqlserverCloudEventsMaker(parser, contentType, dataSchemaUriBase);
            }
        }
        throw new DataException("No usable CloudEvents converters for connector type \"" + parser.connectorType() + "\"");
    }

    public static CloudEventsMaker create(RecordParser parser, SerializerType contentType) {
        return CloudEventsMaker.create(parser, contentType, null);
    }

    private CloudEventsMaker(RecordParser parser, SerializerType contentType, String dataSchemaUriBase) {
        this.recordParser = parser;
        this.dataContentType = contentType;
        this.dataSchemaUriBase = dataSchemaUriBase;
        this.ceDataAttributeSchema = this.recordParser.dataSchema();
    }

    public abstract String ceId();

    public String ceSource(String logicalName) {
        return "/debezium/" + this.recordParser.connectorType() + "/" + logicalName;
    }

    public String ceSpecversion() {
        return CLOUDEVENTS_SPECVERSION;
    }

    public String ceType() {
        return "io.debezium." + this.recordParser.connectorType() + ".datachangeevent";
    }

    public String ceDatacontenttype() {
        return CONTENT_TYPE_NAME_MAP.get((Object)this.dataContentType);
    }

    public String ceDataschemaUri(String schemaId) {
        return this.dataSchemaUriBase + SCHEMA_URL_PATH + schemaId;
    }

    public String ceTime() {
        long time = (Long)this.recordParser.getMetadata("ts_ms");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(time);
    }

    public Schema ceDataAttributeSchema() {
        return this.ceDataAttributeSchema;
    }

    public Struct ceDataAttribute() {
        return this.recordParser.data();
    }

    public String ceEnvelopeSchemaName() {
        return this.recordParser.getMetadata("name") + "." + this.recordParser.getMetadata("db") + ".CloudEvents.Envelope";
    }

    public static final class SqlserverCloudEventsMaker
    extends CloudEventsMaker {
        SqlserverCloudEventsMaker(RecordParser parser, SerializerType contentType, String dataSchemaUriBase) {
            super(parser, contentType, dataSchemaUriBase);
        }

        @Override
        public String ceId() {
            return "name:" + this.recordParser.getMetadata("name") + ";change_lsn:" + this.recordParser.getMetadata("change_lsn") + ";commit_lsn:" + this.recordParser.getMetadata("commit_lsn") + ";event_serial_no:" + this.recordParser.getMetadata("event_serial_no");
        }
    }

    public static final class MongodbCloudEventsMaker
    extends CloudEventsMaker {
        MongodbCloudEventsMaker(RecordParser parser, SerializerType contentType, String dataSchemaUriBase) {
            super(parser, contentType, dataSchemaUriBase);
        }

        @Override
        public String ceId() {
            return "name:" + this.recordParser.getMetadata("name") + ";h:" + this.recordParser.getMetadata("h");
        }
    }

    public static final class PostgresCloudEventsMaker
    extends CloudEventsMaker {
        PostgresCloudEventsMaker(RecordParser parser, SerializerType contentType, String dataSchemaUriBase) {
            super(parser, contentType, dataSchemaUriBase);
        }

        @Override
        public String ceId() {
            return "name:" + this.recordParser.getMetadata("name") + ";lsn:" + this.recordParser.getMetadata("lsn").toString() + ";txId:" + this.recordParser.getMetadata("txId").toString();
        }
    }

    public static final class MysqlCloudEventsMaker
    extends CloudEventsMaker {
        MysqlCloudEventsMaker(RecordParser parser, SerializerType contentType, String dataSchemaUriBase) {
            super(parser, contentType, dataSchemaUriBase);
        }

        @Override
        public String ceId() {
            return "name:" + this.recordParser.getMetadata("name") + ";file:" + this.recordParser.getMetadata("file") + ";pos:" + this.recordParser.getMetadata("pos");
        }
    }

    public static final class FieldName {
        public static final String ID = "id";
        public static final String SOURCE = "source";
        public static final String SPECVERSION = "specversion";
        public static final String TYPE = "type";
        public static final String DATACONTENTTYPE = "datacontenttype";
        public static final String DATASCHEMA = "dataschema";
        public static final String SUBJECT = "subject";
        public static final String TIME = "time";
        public static final String DATA = "data";
        public static final String SCHEMA_FIELD_NAME = "schema";
        public static final String PAYLOAD_FIELD_NAME = "payload";
    }
}

