/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.middlewares;

import cn.ucloud.common.exception.UCloudException;
import cn.ucloud.common.middleware.BaseMiddleware;
import cn.ucloud.common.middleware.Context;
import cn.ucloud.common.middleware.Middleware;
import cn.ucloud.common.request.Request;
import cn.ucloud.common.response.Response;
import com.google.gson.Gson;
import org.slf4j.Logger;

public class LogMiddleware
extends BaseMiddleware
implements Middleware {
    @Override
    public Request handleRequest(Context context) throws UCloudException {
        Logger logger = context.getConfig().getLogger();
        logger.info(new Gson().toJson(context.getRequest().encode()));
        return super.handleRequest(context);
    }

    @Override
    public Response handleResponse(Context context) throws UCloudException {
        Logger logger = context.getConfig().getLogger();
        logger.info(String.format("[%s] %s", context.getResponse().getRequestId(), new Gson().toJson((Object)context.getResponse())));
        return super.handleResponse(context);
    }

    @Override
    public void handleException(Context context) throws UCloudException {
        Logger logger = context.getConfig().getLogger();
        logger.error(new Gson().toJson((Object)context.getException().getMessage()));
        super.handleException(context);
    }
}

