/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.request;

import cn.ucloud.common.annotation.NotEmpty;
import cn.ucloud.common.annotation.UCloudParam;
import cn.ucloud.common.exception.UCloudException;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.request.RequestOptions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request
extends RequestOptions {
    @UCloudParam(value="Signature")
    private String signature;
    @UCloudParam(value="Action")
    private String action;
    @UCloudParam(value="PublicKey")
    private String publicKey;
    @UCloudParam(value="Region")
    private String region;
    @UCloudParam(value="ProjectId")
    private String projectId;

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Map<String, Object> encode() throws UCloudException {
        try {
            return Request.encodeObject(this);
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new UCloudException("cannot encode: " + e.getMessage(), e);
        }
    }

    private static Map<String, Object> encodeObject(Object obj) throws ClassNotFoundException, IllegalAccessException, UCloudException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Field field : Request.getAllFields(obj.getClass())) {
            UCloudParam paramAnnotation = field.getAnnotation(UCloudParam.class);
            if (paramAnnotation == null) continue;
            String key = paramAnnotation.value();
            NotEmpty requiredAnnotation = field.getAnnotation(NotEmpty.class);
            field.setAccessible(true);
            Object value = field.get(obj);
            if (requiredAnnotation != null && value == null) {
                throw new ValidatorException(String.format("%s can not be null", paramAnnotation.value()));
            }
            if (value == null) continue;
            if (Request.isPrimitive(value).booleanValue()) {
                params.put(key, value);
                continue;
            }
            if (Request.isArray(value).booleanValue()) {
                List listValue = (List)value;
                for (int i = 0; i < listValue.size(); ++i) {
                    Object item = listValue.get(i);
                    if (Request.isObject(item).booleanValue()) {
                        for (Map.Entry<String, Object> entry : Request.encodeObject(item).entrySet()) {
                            params.put(String.format("%s.%d.%s", key, i, entry.getKey()), entry.getValue());
                        }
                        continue;
                    }
                    params.put(String.format("%s.%d", key, i), item);
                }
                continue;
            }
            if (Request.isObject(value).booleanValue()) {
                for (Map.Entry<String, Object> entry : Request.encodeObject(value).entrySet()) {
                    params.put(String.format("%s.%s", key, entry.getKey()), entry.getValue());
                }
                continue;
            }
            throw new ClassNotFoundException("invalid class ".concat(value.getClass().getName()));
        }
        return params;
    }

    private static Boolean isArray(Object value) {
        return value instanceof List;
    }

    private static Boolean isObject(Object value) {
        return value instanceof Request;
    }

    private static Boolean isPrimitive(Object value) {
        return value instanceof Number || value instanceof String || value instanceof Boolean;
    }

    private static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields.addAll(Request.getAllFields(type.getSuperclass()));
        }
        return fields;
    }
}

