/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.pathx.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class GetPathXMetricParam
extends BaseRequestParam {
    @UcloudParam(value="ResourceId")
    @NotEmpty(message="resourceId can not be empty")
    private @NotEmpty(message="resourceId can not be empty") String resourceId;
    @UcloudParam(value="BeginTime")
    @NotNull(message="beginTime can not be null")
    private @NotNull(message="beginTime can not be null") Integer beginTime;
    @UcloudParam(value="EndTime")
    @NotNull(message="endTime can not be null")
    private @NotNull(message="endTime can not be null") Integer endTime;
    private List<String> metricNames;
    @UcloudParam(value="ResourceType")
    @NotEmpty(message="resourceType can not be empty")
    private @NotEmpty(message="resourceType can not be empty") String resourceType;
    @UcloudParam(value="LineId")
    @NotEmpty(message="lineId can not be empty")
    private @NotEmpty(message="lineId can not be empty") String lineId;

    public GetPathXMetricParam(String projectId, String resourceId, Integer beginTime, Integer endTime, String resourceType, String lineId, List<String> metricNames) {
        super("GetPathXMetric");
        this.projectId = projectId;
        this.resourceId = resourceId;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.metricNames = metricNames;
        this.resourceType = resourceType;
        this.lineId = lineId;
    }

    @UcloudParam(value="MetricName")
    public List<Param> checkMetricNames() throws ValidationException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.metricNames == null || this.metricNames.isEmpty()) {
            throw new ValidationException("metricNames can not be empty");
        }
        int size = this.metricNames.size();
        for (int i = 0; i < size; ++i) {
            String name = this.metricNames.get(i);
            if (name == null || name.length() <= 0) {
                throw new ValidationException(String.format("metricNames[%d] can not be empty", i));
            }
            params.add(new Param(String.format("MetricName.%d", i), (Object)name));
        }
        return params;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public Integer getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Integer beginTime) {
        this.beginTime = beginTime;
    }

    public Integer getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Integer endTime) {
        this.endTime = endTime;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getLineId() {
        return this.lineId;
    }

    public void setLineId(String lineId) {
        this.lineId = lineId;
    }
}

