/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.pathx.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import cn.ucloud.pathx.model.PathXWhitelist;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.constraints.NotEmpty;

public class InsertPathXWhitelistParam
extends BaseRequestParam {
    @UcloudParam(value="InstanceId")
    @NotEmpty(message="instanceId can not be empty")
    private @NotEmpty(message="instanceId can not be empty") String instanceId;
    private List<PathXWhitelist> whiteList;

    public InsertPathXWhitelistParam(String projectId, String instanceId, List<PathXWhitelist> whiteList) {
        super("InsertPathXWhitelist");
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.whiteList = whiteList;
    }

    @UcloudParam(value="WhiteList")
    public List<Param> checkWhitelist() throws ValidationException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.whiteList == null || this.whiteList.isEmpty()) {
            throw new ValidationException("whiteList can not be empty");
        }
        int size = this.whiteList.size();
        for (int i = 0; i < size; ++i) {
            PathXWhitelist wl = this.whiteList.get(i);
            if (wl == null) {
                throw new ValidationException(String.format("whiteList[%d] can not be empty", i));
            }
            if (wl.getIp() == null || wl.getIp().length() <= 0) {
                throw new ValidationException(String.format("whiteList[%d].ip can not be empty", i));
            }
            if (wl.getProtocol() == null || wl.getProtocol().length() <= 0) {
                throw new ValidationException(String.format("whiteList[%d].protocol can not be empty", i));
            }
            if (wl.getPort() == null || wl.getPort().length() <= 0) {
                throw new ValidationException(String.format("whiteList[%d].port can not be empty", i));
            }
            params.add(new Param(String.format("Whitelist.%d", i), (Object)String.format("%s|%s|%s", wl.getIp(), wl.getProtocol(), wl.getPort())));
        }
        return params;
    }

    public List<PathXWhitelist> getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(List<PathXWhitelist> whiteList) {
        this.whiteList = whiteList;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }
}

