package cn.ucloud.udb.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.pojo.BaseRequestParam;

import javax.validation.constraints.NotEmpty;

/**
 * @Description : 修改云数据库名称 参数类
 * @Author : codezhang
 * @Date : 2019-03-04 18:39
 **/
public class ModifyUDBInstanceNameParam extends BaseRequestParam {

    /**
     * 目标库所在地域。 参见 [地域和可用区列表](../summary/regionlist.html)
     */
    @NotEmpty(message = "region can not be empty")
    @UcloudParam("Region")
    private String region;

    /**
     * 目标库所在可用区。参见 [可用区列表](../summary/regionlist.html)
     */
    @UcloudParam("Zone")
    private String zone;

    /**
     * SQLServer实例的ID
     */
    @NotEmpty(message = "dbId can not be empty")
    @UcloudParam("DBId")
    private String dbId;

    /**
     * 实例的新名字, 长度要求为6~63位
     */
    @UcloudParam("Name")
    @NotEmpty(message = "name can not be empty")
    private String name;

    public ModifyUDBInstanceNameParam(@NotEmpty(message = "region can not be empty") String region,
                                      @NotEmpty(message = "dbId can not be empty") String dbId,
                                      @NotEmpty(message = "name can not be empty") String name) {
        super("ModifyUDBInstanceName");
        this.region = region;
        this.dbId = dbId;
        this.name = name;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getDbId() {
        return dbId;
    }

    public void setDbId(String dbId) {
        this.dbId = dbId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
